/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.util.Util;

public class StepsOverviewPage
extends AbstractPage {
    public StepsOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "stepsOverview.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return "step-overview.html";
    }

    @Override
    public void prepareReport() {
        this.velocityContext.put("all_steps", (Object)this.sortStepsByDuration(this.report.getAllSteps()));
        int allOccurrences = 0;
        long allDurations = 0L;
        for (StepObject stepObject : this.report.getAllSteps()) {
            allOccurrences += stepObject.getTotalOccurrences();
            allDurations += stepObject.getDurations();
        }
        this.velocityContext.put("all_occurrences", (Object)allOccurrences);
        this.velocityContext.put("all_durations", (Object)Util.formatDuration(allDurations));
        long average = allDurations / (long)(allOccurrences == 0 ? 1 : allOccurrences);
        this.velocityContext.put("all_average", (Object)Util.formatDuration(average));
    }

    private StepObject[] sortStepsByDuration(List<StepObject> steps) {
        StepObject[] array = new StepObject[steps.size()];
        Arrays.sort(steps.toArray(array), new DurationCompator());
        return array;
    }

    private static class DurationCompator
    implements Comparator<StepObject> {
        private DurationCompator() {
        }

        @Override
        public int compare(StepObject o1, StepObject o2) {
            return Long.signum(o2.getDurations() - o1.getDurations());
        }
    }
}

