/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.reports.OverviewReport;
import net.masterthought.cucumber.reports.Reportable;
import org.apache.commons.lang.StringUtils;

public class ReportResult {
    private final List<Feature> allFeatures = new ArrayList<Feature>();
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private final Map<String, StepObject> allSteps = new HashMap<String, StepObject>();
    private final StatusCounter featureCounter = new StatusCounter();
    private final String buildTime;
    private final OverviewReport featuresReport = new OverviewReport("Features");
    private final OverviewReport tagsReport = new OverviewReport("Tags");

    public ReportResult(List<Feature> features) {
        this.buildTime = new SimpleDateFormat("dd MMM yyyy, HH:mm").format(new Date());
        for (Feature feature : features) {
            this.processFeature(feature);
        }
    }

    public List<Feature> getAllFeatures() {
        return this.allFeatures;
    }

    public List<TagObject> getAllTags() {
        return new ArrayList<TagObject>(this.allTags.values());
    }

    public List<StepObject> getAllSteps() {
        return new ArrayList<StepObject>(this.allSteps.values());
    }

    public Reportable getFeatureReport() {
        return this.featuresReport;
    }

    public Reportable getTagReport() {
        return this.tagsReport;
    }

    public int getAllPassedFeatures() {
        return this.featureCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailedFeatures() {
        return this.featureCounter.getValueFor(Status.FAILED);
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    private void processFeature(Feature feature) {
        this.allFeatures.add(feature);
        for (Element element : feature.getElements()) {
            ResultsWithMatch[] steps;
            if (element.isScenario()) {
                this.featuresReport.incScenarioFor(element.getStatus());
                for (Tag tag : feature.getTags()) {
                    this.processTag(tag, element, feature.getStatus());
                }
            }
            for (Tag tag : element.getTags()) {
                this.processTag(tag, element, element.getStatus());
            }
            for (Step step : steps = element.getSteps()) {
                this.featuresReport.incStepsFor(step.getStatus());
                this.featuresReport.incDurationBy(step.getDuration());
            }
            this.countSteps(steps);
            this.countSteps(element.getBefore());
            this.countSteps(element.getAfter());
        }
        this.featureCounter.incrementFor(feature.getStatus());
    }

    private void processTag(Tag tag, Element element, Status status) {
        TagObject tagObject = this.addTagObject(tag.getName());
        if (tagObject.addElement(element)) {
            Step[] steps;
            this.tagsReport.incScenarioFor(status);
            for (Step step : steps = element.getSteps()) {
                this.tagsReport.incStepsFor(step.getStatus());
                this.tagsReport.incDurationBy(step.getDuration());
            }
        }
    }

    private void countSteps(ResultsWithMatch[] steps) {
        for (ResultsWithMatch step : steps) {
            Result result;
            String methodName;
            Match match = step.getMatch();
            if (match == null || StringUtils.isEmpty((String)(methodName = match.getLocation()))) continue;
            StepObject stepObject = this.allSteps.get(methodName);
            if (stepObject == null) {
                stepObject = new StepObject(methodName);
            }
            if ((result = step.getResult()) != null) {
                stepObject.addDuration(result.getDuration(), result.getStatus());
            } else {
                stepObject.addDuration(0L, Status.FAILED.name());
            }
            this.allSteps.put(methodName, stepObject);
        }
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getName(), tagObject);
        }
        return tagObject;
    }
}

