/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class Util {
    private static final Logger LOG = LogManager.getLogger(Util.class);
    public static final NumberFormat PERCENT_FORMATTER = NumberFormat.getPercentInstance(Locale.US);
    private static final PeriodFormatter TIME_FORMATTER;

    public static String formatDuration(long duration) {
        return TIME_FORMATTER.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public static void unzipToFile(File srcZipFile, String destDirectory) {
        try {
            ZipFile zipFile = new ZipFile(srcZipFile);
            zipFile.extractAll(destDirectory);
        }
        catch (ZipException e) {
            LOG.error("Could not unzip {} into {}.", new Object[]{srcZipFile.getAbsolutePath(), destDirectory, e});
        }
    }

    public static String formatMessage(String message, int messageId) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)message)) {
            sb.append("");
        } else {
            sb.append("<div class=\"output_message\">");
            String[] headLineAndMessage = StringUtils.split((String)message, (String)"\n", (int)2);
            if (headLineAndMessage.length == 2) {
                sb.append(String.format("<input class=\"output_collapse\" id=\"output_%d\" type=\"checkbox\">", messageId));
                sb.append(String.format("<label for=\"output_%d\">%s</label>", messageId, headLineAndMessage[0]));
                sb.append(String.format("<div>%s</div>", headLineAndMessage[1].replaceAll("\n", "<br/>")));
            } else {
                sb.append(message.replaceAll("\\\\n", "<br/>"));
            }
            sb.append("</div>");
        }
        return sb.toString();
    }

    public static String toValidFileName(String value) {
        return value.replaceAll("[^\\d\\w]", "-");
    }

    static {
        PERCENT_FORMATTER.setMinimumFractionDigits(2);
        PERCENT_FORMATTER.setMaximumFractionDigits(2);
        TIME_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").minimumPrintedDigits(2).appendSeconds().appendSuffix("s").appendSeparator(" ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    }
}

