/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;

public class StepObject {
    public final String location;
    private long totalDuration;
    private int totalOccurrences;
    private final StatusCounter statusCounter = new StatusCounter();

    public StepObject(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void addDuration(long duration, String status) {
        this.totalDuration += duration;
        ++this.totalOccurrences;
        this.statusCounter.incrementFor(Status.toStatus(status));
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public String getTotalFormattedDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public String getAverageFormattedDuration() {
        return Util.formatDuration(this.totalDuration / (long)this.totalOccurrences);
    }

    public int getTotalOccurrences() {
        return this.totalOccurrences;
    }

    public float getPercentageResult() {
        int total = 0;
        for (Status status : Status.values()) {
            total += this.statusCounter.getValueFor(status);
        }
        if (total == 0) {
            return 0.0f;
        }
        return 100.0f * (float)this.statusCounter.getValueFor(Status.PASSED) / (float)total;
    }
}

