/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.ErrorPage;
import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class AbstractPage {
    private static final Logger LOG = LogManager.getLogger(AbstractPage.class);
    protected final VelocityEngine ve = new VelocityEngine();
    protected final VelocityContext velocityContext = new VelocityContext();
    private Template template;
    private final String templateFileName;
    protected final ReportResult report;
    protected final Configuration configuration;
    protected final String targetFileName;

    protected AbstractPage(ReportResult reportResult, String templateFileName, Configuration configuration, String targetFileName) {
        this.templateFileName = templateFileName;
        this.report = reportResult;
        this.configuration = configuration;
        this.targetFileName = targetFileName;
        this.buildGeneralParameters();
    }

    public final void generatePage() {
        this.ve.init(this.getProperties());
        this.template = this.ve.getTemplate("templates/pages/" + this.templateFileName);
        if (this instanceof ErrorPage) {
            this.velocityContext.put("time_stamp", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
        } else {
            this.velocityContext.put("time_stamp", (Object)this.report.timeStamp());
        }
        this.prepareReport();
        this.generateReport();
    }

    protected abstract void prepareReport();

    private void generateReport() {
        this.velocityContext.put("page_url", (Object)this.targetFileName);
        File dir = new File(this.configuration.getReportDirectory(), this.targetFileName);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dir), Charsets.UTF_8);){
            this.template.merge((Context)this.velocityContext, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.configuration.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    private void buildGeneralParameters() {
        this.velocityContext.put("jenkins_source", (Object)this.configuration.isRunWithJenkins());
        this.velocityContext.put("jenkins_base", (Object)this.configuration.getJenkinsBasePath());
        this.velocityContext.put("build_project", (Object)this.configuration.getProjectName());
        this.velocityContext.put("build_number", (Object)this.configuration.getBuildNumber());
        if (this.configuration.isRunWithJenkins()) {
            int buildNumber = -1;
            try {
                buildNumber = Integer.parseInt(this.configuration.getBuildNumber());
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse build number: {}.", new Object[]{this.configuration.getBuildNumber(), e});
            }
            this.velocityContext.put("build_previous_number", (Object)(--buildNumber));
        }
    }
}

