/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.Feature;

public class ReportParser {
    private final Configuration configuration;

    public ReportParser(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<Feature> parseJsonResults(List<String> jsonReportFiles) throws IOException, JsonSyntaxException {
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        Gson gson = new Gson();
        for (int i = 0; i < jsonReportFiles.size(); ++i) {
            String jsonFile = jsonReportFiles.get(i);
            try (FileInputStream in = new FileInputStream(jsonFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                Feature[] features = (Feature[])gson.fromJson((Reader)reader, Feature[].class);
                if (features == null) {
                    throw new IllegalArgumentException(String.format("File '%s' does not contan features!", jsonFile));
                }
                this.setMetadata(features, jsonFile, i);
                featureResults.addAll(Arrays.asList(features));
                continue;
            }
        }
        return featureResults;
    }

    private void setMetadata(Feature[] features, String jsonFile, int jsonFileNo) {
        for (Feature feature : features) {
            feature.setMetaData(jsonFile, jsonFileNo, this.configuration);
        }
    }
}

