import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.velocity.exception.VelocityException;

import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;

public class HelloCucumber {

    public static void main(String[] args) throws VelocityException, IOException {
        File reportOutputDirectory = new File("target");
        List<String> jsonFiles = new ArrayList<>();
        // jsonFiles.add("cucumber-RIFE-config.json");
        jsonFiles.add("cucumber-RIFE-sales.json");
        // jsonFiles.add("attachments.json");

        String jenkinsBasePath = "";
        String buildNumber = "1";
        String projectName = "Damian2";
        boolean skippedFailsBuild = false;
        boolean pendingFailsBuild = false;
        boolean undefinedFailsBuild = true;
        boolean missingFailsBuild = false;
        boolean runWithJenkins = true;
        boolean parallelTesting = false;

        // optionally only if you need
        Configuration configuration = new Configuration(reportOutputDirectory, projectName);
        configuration.setStatusFlags(skippedFailsBuild, pendingFailsBuild, undefinedFailsBuild, missingFailsBuild);
        configuration.setParallelTesting(parallelTesting);
        configuration.setJenkinsBasePath(jenkinsBasePath);
        configuration.setRunWithJenkins(runWithJenkins);
        configuration.setBuildNumber(buildNumber);

        ReportBuilder reportBuilder = new ReportBuilder(jsonFiles, configuration);
        reportBuilder.generateReports();
    }
}
