/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Element {
    private final String id;
    private final String name;
    private final String type;
    private final String description;
    private final String keyword;
    private final Step[] steps = new Step[0];
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    private final Tag[] tags = new Tag[0];
    private static final String[] SCENARIO_KEYWORDS = new String[]{"Scenario", "Scenario Outline"};
    private String beforeAttachments;
    private String afterAttachments;
    private StatusCounter statusCounter;
    private Feature feature;

    public Element() {
        this.id = null;
        this.name = null;
        this.type = null;
        this.description = null;
        this.keyword = null;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getBeforeAttachments() {
        return this.beforeAttachments;
    }

    public String getAfterAttachments() {
        return this.afterAttachments;
    }

    public Status getStatus() {
        if (this.statusCounter.getValueFor(Status.FAILED) > 0) {
            return Status.FAILED;
        }
        ConfigurationOptions configuration = ConfigurationOptions.instance();
        if (configuration.skippedFailsBuild() && this.statusCounter.getValueFor(Status.SKIPPED) > 0) {
            return Status.FAILED;
        }
        if (configuration.pendingFailsBuild() && this.statusCounter.getValueFor(Status.PENDING) > 0) {
            return Status.FAILED;
        }
        if (configuration.undefinedFailsBuild() && this.statusCounter.getValueFor(Status.UNDEFINED) > 0) {
            return Status.FAILED;
        }
        if (configuration.missingFailsBuild() && this.statusCounter.getValueFor(Status.MISSING) > 0) {
            return Status.FAILED;
        }
        return Status.PASSED;
    }

    public String getId() {
        return this.id;
    }

    public String getRawName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getType() {
        return this.type;
    }

    public boolean isScenario() {
        for (String reference : SCENARIO_KEYWORDS) {
            if (!reference.equals(this.keyword)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"").append(this.getStatus().getName().toLowerCase()).append("\">");
        if (StringUtils.isNotEmpty((String)this.keyword)) {
            sb.append("<span class=\"element-keyword\">").append(StringEscapeUtils.escapeHtml((String)this.keyword)).append(": </span>");
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            sb.append("<span class=\"element-name\">").append(StringEscapeUtils.escapeHtml((String)this.name)).append("</span>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    public boolean hasTags() {
        return this.tags.length > 0;
    }

    public boolean hasSteps() {
        return this.steps.length > 0;
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        return this.id != null ? this.id.equals(other.id) : super.equals(obj);
    }

    public void setMedaData(Feature feature) {
        this.feature = feature;
        for (Step step : this.steps) {
            step.setMedaData(this);
        }
        this.calculateStatus();
        this.calculateHooks(this.before);
        this.calculateHooks(this.after);
        this.beforeAttachments = this.calculateAttachments("Before", this.before);
        this.afterAttachments = this.calculateAttachments("After", this.after);
    }

    private void calculateStatus() {
        this.statusCounter = new StatusCounter();
        for (Step step : this.steps) {
            this.statusCounter.incrementFor(step.getStatus());
        }
    }

    private void calculateHooks(Hook[] hooks) {
        for (int i = 0; i < hooks.length; ++i) {
            hooks[i].setMedaData();
        }
    }

    private String calculateAttachments(String keyword, Hook[] hooks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hooks.length; ++i) {
            String status = hooks[i].getResult().getStatus();
            sb.append("<div class=\"").append(status).append("\">");
            sb.append("<span class=\"step-keyword\">").append(keyword).append(" </span>");
            sb.append("<i>").append(hooks[i].getMatch().getLocation()).append("</i>");
            sb.append("<span class=\"step-duration\">");
            if (Status.MISSING.getName().equals(status)) {
                sb.append(Util.formatDuration(hooks[i].getResult().getDuration()));
            }
            sb.append("</span>");
            sb.append(Util.formatErrorMessage(hooks[i].getResult().getErrorMessage(), hooks[i].getResult().hashCode()));
            sb.append("</div>");
            sb.append(hooks[i].getAttachments());
        }
        return sb.toString();
    }
}

