/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;

public class TagOverviewPage
extends AbstractPage {
    public TagOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "tagOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        List<TagObject> tags = this.reportInformation.getAllTags();
        this.contextMap.put("all_tags", (Object)tags);
        this.contextMap.put("all_tags_scenarios", (Object)this.reportInformation.getAllTagScenarios());
        this.contextMap.put("all_tags_passed_scenarios", (Object)this.reportInformation.getAllPassedTagScenarios());
        this.contextMap.put("all_tags_failed_scenarios", (Object)this.reportInformation.getAllFailedTagScenarios());
        this.contextMap.put("all_tags_steps", (Object)this.reportInformation.getAllTagSteps());
        this.contextMap.put("all_tags_passes", (Object)this.reportInformation.getAllPassesTags());
        this.contextMap.put("all_tags_failed", (Object)this.reportInformation.getAllFailsTags());
        this.contextMap.put("all_tags_skipped", (Object)this.reportInformation.getAllSkippedTags());
        this.contextMap.put("all_tags_pending", (Object)this.reportInformation.getAllPendingTags());
        this.contextMap.put("all_tags_undefined", (Object)this.reportInformation.getAllUndefinedTags());
        this.contextMap.put("all_tags_missing", (Object)this.reportInformation.getAllMissingTags());
        boolean flashCharts = this.reportBuilder.isFlashCharts();
        boolean highCharts = this.reportBuilder.isHighCharts();
        if (flashCharts) {
            this.contextMap.put("chart_data", (Object)FlashChartBuilder.generateStackedColumnChart(tags));
        } else if (highCharts) {
            this.contextMap.put("chart_categories", (Object)JsChartUtil.getTags(tags));
            this.contextMap.put("chart_data", (Object)JsChartUtil.generateTagChartDataForHighCharts(tags));
        } else {
            this.contextMap.put("chart_rows", (Object)JsChartUtil.generateTagChartData(tags));
        }
        this.contextMap.put("all_durations", (Object)Util.formatDuration(this.reportInformation.getAllTagDuration()));
        this.contextMap.put("flash_charts", (Object)flashCharts);
        this.contextMap.put("high_charts", (Object)highCharts);
        super.generateReport("tag-overview.html");
    }
}

