/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.util.Util;

public class StepOverviewPage
extends AbstractPage {
    public StepOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "stepOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        this.contextMap.put("all_steps", (Object)this.sortStepsByDuration(this.reportInformation.getAllSteps()));
        int allOccurrences = 0;
        long allDurations = 0L;
        for (StepObject stepObject : this.reportInformation.getAllSteps()) {
            allOccurrences += stepObject.getTotalOccurrences();
            allDurations += stepObject.getTotalDuration();
        }
        this.contextMap.put("all_occurrences", (Object)allOccurrences);
        this.contextMap.put("all_durations", (Object)Util.formatDuration(allDurations));
        long average = allDurations / (long)(allOccurrences == 0 ? 1 : allOccurrences);
        this.contextMap.put("all_average", (Object)Util.formatDuration(average));
        super.generateReport("step-overview.html");
    }

    private StepObject[] sortStepsByDuration(List<StepObject> steps) {
        StepObject[] array = new StepObject[steps.size()];
        Arrays.sort(steps.toArray(array), new DurationCompator());
        return array;
    }

    private static class DurationCompator
    implements Comparator<StepObject> {
        private DurationCompator() {
        }

        @Override
        public int compare(StepObject o1, StepObject o2) {
            return Long.signum(o2.getTotalDuration() - o1.getTotalDuration());
        }
    }
}

