/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.generators.AbstractPage;

public class FeatureOverviewPage
extends AbstractPage {
    public FeatureOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "featureOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        this.contextMap.put("all_features", (Object)this.reportInformation.getAllFeatures());
        this.contextMap.put("all_steps", (Object)this.reportInformation.getStepsCounter());
        this.contextMap.put("all_steps_passes", (Object)this.reportInformation.getAllPassedSteps());
        this.contextMap.put("all_steps_failed", (Object)this.reportInformation.getAllFailedSteps());
        this.contextMap.put("all_steps_skipped", (Object)this.reportInformation.getAllSkippedSteps());
        this.contextMap.put("all_steps_pending", (Object)this.reportInformation.getPendingStepsl());
        this.contextMap.put("all_steps_undefined", (Object)this.reportInformation.getUndefinedSteps());
        this.contextMap.put("all_steps_missing", (Object)this.reportInformation.getTotalStepsMissing());
        this.contextMap.put("all_scenarios", (Object)this.reportInformation.getAllScenarios().size());
        this.contextMap.put("all_scenarios_passed", (Object)this.reportInformation.getAllPassedScenarios());
        this.contextMap.put("all_scenarios_failed", (Object)this.reportInformation.getAllFailedScenarios());
        if (this.reportBuilder.isFlashCharts()) {
            this.contextMap.put("step_data", (Object)FlashChartBuilder.getStepsChart(this.reportInformation.getAllPassedSteps(), this.reportInformation.getAllFailedSteps(), this.reportInformation.getAllSkippedSteps(), this.reportInformation.getPendingStepsl(), this.reportInformation.getUndefinedSteps(), this.reportInformation.getTotalStepsMissing()));
            this.contextMap.put("scenario_data", (Object)FlashChartBuilder.pieScenariosChart(this.reportInformation.getAllPassedScenarios(), this.reportInformation.getAllFailedScenarios()));
        } else {
            JsChartUtil pie = new JsChartUtil();
            List<String> stepColours = pie.orderStepsByValue(this.reportInformation.getAllPassedSteps(), this.reportInformation.getAllFailedSteps(), this.reportInformation.getAllSkippedSteps(), this.reportInformation.getPendingStepsl(), this.reportInformation.getUndefinedSteps(), this.reportInformation.getTotalStepsMissing());
            this.contextMap.put("step_data", (Object)stepColours);
            List<String> scenarioColours = pie.orderScenariosByValue(this.reportInformation.getAllPassedScenarios(), this.reportInformation.getAllFailedScenarios());
            this.contextMap.put("scenario_data", (Object)scenarioColours);
        }
        this.contextMap.put("all_durations", (Object)this.reportInformation.getAllDurationsAsString());
        this.contextMap.put("flash_charts", (Object)this.reportBuilder.isFlashCharts());
        this.contextMap.put("high_charts", (Object)this.reportBuilder.isHighCharts());
        this.contextMap.put("parallel", (Object)ReportBuilder.isParallel());
        super.generateReport("feature-overview.html");
    }
}

