/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.charts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.TagObject;

public class JsChartUtil {
    public List<String> orderStepsByValue(int numberTotalPassed, int numberTotalFailed, int numberTotalSkipped, int numberTotalPending, int numberTotalUndefined, int numberTotalMissing) {
        HashMap<Status, Integer> map = new HashMap<Status, Integer>();
        map.put(Status.PASSED, numberTotalPassed);
        map.put(Status.FAILED, numberTotalFailed);
        map.put(Status.SKIPPED, numberTotalSkipped);
        map.put(Status.PENDING, numberTotalPending);
        map.put(Status.UNDEFINED, numberTotalUndefined);
        map.put(Status.MISSING, numberTotalMissing);
        return this.getKeysSortedByValue(map);
    }

    public List<String> orderScenariosByValue(int numberTotalPassed, int numberTotalFailed) {
        HashMap<Status, Integer> map = new HashMap<Status, Integer>();
        map.put(Status.PASSED, numberTotalPassed);
        map.put(Status.FAILED, numberTotalFailed);
        return this.getKeysSortedByValue(map);
    }

    private List<String> getKeysSortedByValue(Map<Status, Integer> map) {
        ArrayList<Map.Entry<Status, Integer>> list = new ArrayList<Map.Entry<Status, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Status, Integer>>(){

            @Override
            public int compare(Map.Entry<Status, Integer> o1, Map.Entry<Status, Integer> o2) {
                int valueOrder = o2.getValue().compareTo(o1.getValue());
                if (valueOrder != 0) {
                    return valueOrder;
                }
                int colorOrder = o1.getKey().compareTo((Enum)o2.getKey());
                return colorOrder;
            }
        });
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry entry : list) {
            keys.add(((Status)((Object)entry.getKey())).color);
        }
        return keys;
    }

    public static String generateTagChartData(List<TagObject> tagObjectList) {
        StringBuilder buffer = new StringBuilder();
        for (TagObject tag : tagObjectList) {
            buffer.append("[[");
            buffer.append(tag.getNumberOfPasses());
            buffer.append(",");
            buffer.append(tag.getNumberOfFailures());
            buffer.append(",");
            buffer.append(tag.getNumberOfSkipped());
            buffer.append(",");
            buffer.append(tag.getNumberOfPending());
            buffer.append("],");
            buffer.append("{label:'").append(tag.getTagName()).append("'}],");
        }
        return buffer.toString();
    }

    public static String getTags(List<TagObject> tagObjectList) {
        StringBuilder tags = new StringBuilder();
        if (!tagObjectList.isEmpty()) {
            for (TagObject tag : tagObjectList) {
                tags.append("'").append(tag.getTagName()).append("',");
            }
            tags.setLength(tags.length() - 1);
        }
        return "[" + tags.toString() + "]";
    }

    public static String generateTagChartDataForHighCharts(List<TagObject> tagObjectList) {
        StringBuilder buffer = new StringBuilder();
        if (!tagObjectList.isEmpty()) {
            for (TagObject tag : tagObjectList) {
                buffer.append("[");
                buffer.append(tag.getNumberOfPasses());
                buffer.append(",");
                buffer.append(tag.getNumberOfFailures());
                buffer.append(",");
                buffer.append(tag.getNumberOfSkipped());
                buffer.append(",");
                buffer.append(tag.getNumberOfPending());
                buffer.append("]");
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
        }
        return "[" + buffer.toString() + "]";
    }
}

