/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.json.Feature;

public class ReportParser {
    public List<Feature> parseJsonResults(List<String> jsonReportFiles) throws IOException, JsonSyntaxException {
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        Gson gson = new Gson();
        for (String jsonFile : jsonReportFiles) {
            FileInputStream in = new FileInputStream(jsonFile);
            Throwable throwable = null;
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    Feature[] features = (Feature[])gson.fromJson((Reader)reader, Feature[].class);
                    if (features == null) {
                        throw new IllegalArgumentException(String.format("File '%s' does not contan features!", jsonFile));
                    }
                    this.setMetadata(features, jsonFile);
                    featureResults.addAll(Arrays.asList(features));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        return featureResults;
    }

    private void setMetadata(Feature[] features, String jsonFile) {
        for (Feature feature : features) {
            feature.setMetaData(jsonFile);
        }
    }
}

