/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

public class ReportInformation {
    private final List<Feature> allFeatures;
    private long allDurations;
    private long allTagDuration;
    private int allTagSteps;
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private final Map<String, StepObject> allSteps = new HashMap<String, StepObject>();
    private final StatusCounter tagsStatusCounter = new StatusCounter();
    private final StatusCounter tagsCounter = new StatusCounter();
    private final StatusCounter scenarioCounter = new StatusCounter();
    private final StatusCounter stepStatusCounter = new StatusCounter();

    public ReportInformation(List<Feature> features) {
        this.allFeatures = features;
        this.processFeatures();
    }

    public List<Feature> getAllFeatures() {
        return this.allFeatures;
    }

    public List<TagObject> getAllTags() {
        return new ArrayList<TagObject>(this.allTags.values());
    }

    public List<StepObject> getAllSteps() {
        return new ArrayList<StepObject>(this.allSteps.values());
    }

    public StatusCounter getAllScenarios() {
        return this.scenarioCounter;
    }

    public StatusCounter getStepsCounter() {
        return this.stepStatusCounter;
    }

    public int getAllPassedSteps() {
        return this.stepStatusCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailedSteps() {
        return this.stepStatusCounter.getValueFor(Status.FAILED);
    }

    public int getAllSkippedSteps() {
        return this.stepStatusCounter.getValueFor(Status.SKIPPED);
    }

    public int getPendingStepsl() {
        return this.stepStatusCounter.getValueFor(Status.PENDING);
    }

    public int getTotalStepsMissing() {
        return this.stepStatusCounter.getValueFor(Status.MISSING);
    }

    public int getUndefinedSteps() {
        return this.stepStatusCounter.getValueFor(Status.UNDEFINED);
    }

    public String getAllDurationsAsString() {
        return Util.formatDuration(this.allDurations);
    }

    public Long getAllDurations() {
        return this.allDurations;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public int getAllTagScenarios() {
        return this.tagsCounter.size();
    }

    public int getAllPassedTagScenarios() {
        return this.tagsCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailedTagScenarios() {
        return this.tagsCounter.getValueFor(Status.FAILED);
    }

    public int getAllTagSteps() {
        return this.allTagSteps;
    }

    public int getAllPassesTags() {
        return this.tagsStatusCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailsTags() {
        return this.tagsStatusCounter.getValueFor(Status.FAILED);
    }

    public int getAllSkippedTags() {
        return this.tagsStatusCounter.getValueFor(Status.SKIPPED);
    }

    public int getAllPendingTags() {
        return this.tagsStatusCounter.getValueFor(Status.PENDING);
    }

    public int getAllUndefinedTags() {
        return this.tagsStatusCounter.getValueFor(Status.UNDEFINED);
    }

    public int getAllMissingTags() {
        return this.tagsStatusCounter.getValueFor(Status.MISSING);
    }

    public long getAllTagDuration() {
        return this.allTagDuration;
    }

    public int getAllPassedScenarios() {
        return this.scenarioCounter.getValueFor(Status.PASSED);
    }

    public int getAllFailedScenarios() {
        return this.scenarioCounter.getValueFor(Status.FAILED);
    }

    private void processFeatures() {
        for (Feature feature : this.allFeatures) {
            for (Element element : feature.getElements()) {
                ResultsWithMatch[] steps;
                if (element.isScenario()) {
                    this.scenarioCounter.incrementFor(element.getStatus());
                }
                for (Tag tag : element.getTags()) {
                    this.tagsCounter.incrementFor(element.getStatus());
                    TagObject tagObject = this.addTagObject(tag.getName());
                    this.processTag(tagObject, element);
                }
                for (Step step : steps = element.getSteps()) {
                    this.stepStatusCounter.incrementFor(step.getStatus());
                    this.allDurations += step.getDuration();
                }
                this.countSteps(steps);
                this.countSteps(element.getBefore());
                this.countSteps(element.getAfter());
            }
        }
    }

    private void processTag(TagObject tag, Element element) {
        Step[] steps;
        tag.addElement(element);
        for (Step step : steps = element.getSteps()) {
            this.tagsStatusCounter.incrementFor(step.getStatus());
            this.allTagDuration += step.getDuration();
        }
        this.allTagSteps += steps.length;
    }

    private void countSteps(ResultsWithMatch[] steps) {
        for (ResultsWithMatch step : steps) {
            Result result;
            String methodName;
            Match match = step.getMatch();
            if (match == null || StringUtils.isEmpty((String)(methodName = match.getLocation()))) continue;
            StepObject stepObject = this.allSteps.get(methodName);
            if (stepObject == null) {
                stepObject = new StepObject(methodName);
            }
            if ((result = step.getResult()) != null) {
                stepObject.addDuration(result.getDuration(), result.getStatus());
            } else {
                stepObject.addDuration(0L, Status.FAILED.name());
            }
            this.allSteps.put(methodName, stepObject);
        }
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getTagName(), tagObject);
        }
        return tagObject;
    }
}

