/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ReportInformation;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FeatureOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.StepOverviewPage;
import net.masterthought.cucumber.generators.TagOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class ReportBuilder {
    private static final Logger LOG = LogManager.getLogger(ReportBuilder.class);
    private ReportInformation reportInformation;
    private List<String> jsonFiles;
    private File reportDirectory;
    private String buildNumber;
    private String buildProject;
    private String pluginUrlPath;
    private boolean flashCharts;
    private boolean runWithJenkins;
    private boolean highCharts;
    private static boolean parallel = false;

    public ReportInformation getReportInformation() {
        return this.reportInformation;
    }

    public static boolean isParallel() {
        return parallel;
    }

    public static void setParallel(boolean p) {
        parallel = p;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(File reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildProject() {
        return this.buildProject;
    }

    public void setBuildProject(String buildProject) {
        this.buildProject = buildProject;
    }

    public String getPluginUrlPath() {
        return this.pluginUrlPath;
    }

    public void setPluginUrlPath(String pluginUrlPath) {
        this.pluginUrlPath = pluginUrlPath;
    }

    public boolean isRunWithJenkins() {
        return this.runWithJenkins;
    }

    public void setRunWithJenkins(boolean runWithJenkins) {
        this.runWithJenkins = runWithJenkins;
    }

    public boolean isFlashCharts() {
        return this.flashCharts;
    }

    public void setFlashCharts(boolean flashCharts) {
        this.flashCharts = flashCharts;
    }

    public boolean isHighCharts() {
        return this.highCharts;
    }

    public void setHighCharts(boolean highCharts) {
        this.highCharts = highCharts;
    }

    public List<String> getJsonFiles() {
        return this.jsonFiles;
    }

    public ReportBuilder(List<String> jsonReports, File reportDirectory, String pluginUrlPath, String buildNumber, String buildProject, boolean skippedFails, boolean pendingFails, boolean undefinedFails, boolean missingFails, boolean flashCharts, boolean runWithJenkins, boolean highCharts, boolean parallelTesting) throws IOException, VelocityException {
        try {
            this.reportDirectory = reportDirectory;
            this.buildNumber = buildNumber;
            this.buildProject = buildProject;
            this.pluginUrlPath = this.getPluginUrlPath(pluginUrlPath);
            this.flashCharts = flashCharts;
            this.runWithJenkins = runWithJenkins;
            this.highCharts = highCharts;
            parallel = parallelTesting;
            this.jsonFiles = jsonReports;
            ConfigurationOptions configuration = ConfigurationOptions.instance();
            configuration.setSkippedFailsBuild(skippedFails);
            configuration.setPendingFailsBuild(pendingFails);
            configuration.setUndefinedFailsBuild(undefinedFails);
            configuration.setMissingFailsBuild(missingFails);
        }
        catch (Exception e) {
            this.generateErrorPage(e);
        }
    }

    public boolean hasBuildPassed() {
        return this.reportInformation != null && this.reportInformation.getAllFailedSteps() == 0;
    }

    public void generateReports() throws IOException, VelocityException {
        try {
            ReportParser reportParser = new ReportParser();
            List<Feature> features = reportParser.parseJsonResults(this.jsonFiles);
            this.reportInformation = new ReportInformation(features);
            this.copyResource("themes", "blue.zip");
            this.copyResource("charts", "js.zip");
            if (this.flashCharts) {
                this.copyResource("charts", "flash_charts.zip");
            }
            new FeatureOverviewPage(this).generatePage();
            new FeatureReportPage(this).generatePage();
            new TagReportPage(this).generatePage();
            new TagOverviewPage(this).generatePage();
            new StepOverviewPage(this).generatePage();
        }
        catch (Exception e) {
            this.generateErrorPage(e);
        }
    }

    private void copyResource(String resourceLocation, String resourceName) throws IOException, URISyntaxException {
        File tempFile = new File(this.reportDirectory.getAbsoluteFile(), resourceName);
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resourceName), (File)tempFile);
        Util.unzipToFile(tempFile, this.reportDirectory.getAbsolutePath());
        tempFile.delete();
    }

    private String getPluginUrlPath(String path) {
        return path.isEmpty() ? "/" : path;
    }

    private void generateErrorPage(Exception exception) throws IOException {
        LOG.info((Object)exception);
        ErrorPage errorPage = new ErrorPage(this, exception);
        errorPage.generatePage();
    }
}

