/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

public enum Status {
    PASSED("#00CE00"),
    FAILED("#FF0000"),
    SKIPPED("#88AAFF"),
    PENDING("#FBB907"),
    UNDEFINED("#FBB957"),
    MISSING("#FBB9A7");

    public final String color;

    private Status(String color) {
        this.color = color;
    }

    public static Status[] getOrderedStatuses() {
        return new Status[]{PASSED, FAILED, SKIPPED, PENDING, UNDEFINED, MISSING};
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public String getLabel() {
        return String.valueOf(this.name().charAt(0)).toUpperCase() + this.name().substring(1).toLowerCase();
    }

    public String toHtmlClass() {
        return "<div class=\"" + this.getName().toLowerCase() + "\">";
    }
}

