/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import java.util.ArrayList;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Scenario {
    private static final String SCENARIO_TYPE = "scenario";
    private final String id;
    private final String name;
    private final String type;
    private final String description;
    private final String keyword;
    private final Step[] steps = new Step[0];
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    private final Tag[] tags = new Tag[0];

    public Scenario() {
        this.id = null;
        this.name = null;
        this.type = null;
        this.description = null;
        this.keyword = null;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Status getStatus() {
        if (this.containsStepWithStatus(Status.FAILED)) {
            return Status.FAILED;
        }
        ConfigurationOptions configuration = ConfigurationOptions.instance();
        if (configuration.skippedFailsBuild() && this.containsStepWithStatus(Status.SKIPPED)) {
            return Status.FAILED;
        }
        if (configuration.pendingFailsBuild() && this.containsStepWithStatus(Status.PENDING)) {
            return Status.FAILED;
        }
        if (configuration.undefinedFailsBuild() && this.containsStepWithStatus(Status.UNDEFINED)) {
            return Status.FAILED;
        }
        if (configuration.missingFailsBuild() && this.containsStepWithStatus(Status.MISSING)) {
            return Status.FAILED;
        }
        return Status.PASSED;
    }

    private boolean containsStepWithStatus(Status status) {
        for (Step step : this.steps) {
            if (step.getStatus() != status) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getRawName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        ArrayList<String> contentString = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.keyword)) {
            contentString.add("<span class=\"scenario-keyword\">" + StringEscapeUtils.escapeHtml((String)this.keyword) + ": </span>");
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            contentString.add("<span class=\"scenario-name\">" + StringEscapeUtils.escapeHtml((String)this.name) + "</span>");
        }
        return !contentString.isEmpty() ? this.getStatus().toHtmlClass() + StringUtils.join((Object[])contentString.toArray(), (String)" ") + "</div>" : "";
    }

    public boolean hasTags() {
        return this.tags.length > 0;
    }

    public boolean hasSteps() {
        return this.steps.length > 0;
    }

    public boolean isScenario() {
        return SCENARIO_TYPE.equals(this.type);
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scenario other = (Scenario)obj;
        return this.id != null ? this.id.equals(other.id) : other.id == null;
    }
}

