/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepResults;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Feature {
    private final String id;
    private final String name;
    private final String uri;
    private final String description;
    private final String keyword;
    private final Scenario[] elements = new Scenario[0];
    private final Tag[] tags = new Tag[0];
    private String fileName;
    private String deviceName;
    private StepResults stepResults;
    private List<Scenario> passedScenarios;
    private List<Scenario> failedScenarios;
    private String jsonFile = "";

    public Feature() {
        this.id = null;
        this.name = null;
        this.uri = null;
        this.description = null;
        this.keyword = null;
    }

    public String getDeviceName() {
        if (this.deviceName == null) {
            String[] splitedJsonFile = this.jsonFile.split("[^\\d\\w]");
            this.deviceName = splitedJsonFile.length > 1 ? splitedJsonFile[splitedJsonFile.length - 2] : splitedJsonFile[0];
        }
        return this.deviceName;
    }

    public String getId() {
        return this.id;
    }

    public void setJsonFile(String json) {
        this.jsonFile = json;
    }

    public Scenario[] getScenarios() {
        return this.elements;
    }

    public String getFileName() {
        if (this.fileName == null) {
            String[] splitedJsonFile;
            this.fileName = this.uri.replaceAll("[^\\d\\w]", "-");
            if (ReportBuilder.isParallel() && !this.jsonFile.isEmpty() && (splitedJsonFile = this.jsonFile.split("_")).length > 1) {
                this.fileName = this.fileName + "-" + this.getDeviceName();
            }
            this.fileName = this.fileName + ".html";
        }
        return this.fileName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasTags() {
        return !ArrayUtils.isEmpty((Object[])this.tags);
    }

    public boolean hasScenarios() {
        return this.elements.length > 0;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public Status getStatus() {
        for (Scenario element : this.elements) {
            if (element.getStatus() == Status.PASSED) continue;
            return Status.FAILED;
        }
        return Status.PASSED;
    }

    public String getName() {
        return StringUtils.isNotEmpty((String)this.name) ? this.getStatus().toHtmlClass() + "<div class=\"feature-line\"><span class=\"feature-keyword\">" + this.keyword + ":</span> " + this.name + "</div></div>" : "";
    }

    public String getRawName() {
        return StringUtils.isNotEmpty((String)this.name) ? StringEscapeUtils.escapeHtml((String)this.name) : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        String result = "";
        if (StringUtils.isNotEmpty((String)this.description)) {
            String content = this.description.replaceFirst("As an", "<span class=\"feature-role\">As an</span>");
            content = content.replaceFirst("I want to", "<span class=\"feature-action\">I want to</span>");
            content = content.replaceFirst("So that", "<span class=\"feature-value\">So that</span>");
            content = content.replaceAll("\n", "<br/>");
            result = "<div class=\"feature-description\">" + content + "</div>";
        }
        return result;
    }

    public int getNumberOfScenarios() {
        int result = 0;
        if (this.elements != null) {
            ArrayList<Scenario> elementList = new ArrayList<Scenario>();
            for (Scenario element : this.elements) {
                if (!element.isScenario()) continue;
                elementList.add(element);
            }
            result = elementList.size();
        }
        return result;
    }

    public int getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public int getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public int getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public int getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public int getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public int getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public int getNumberOfUndefined() {
        return this.stepResults.getNumberOfUndefined();
    }

    public String getTotalDuration() {
        return this.stepResults.getTotalDurationAsString();
    }

    public int getNumberOfScenariosPassed() {
        return this.passedScenarios.size();
    }

    public int getNumberOfScenariosFailed() {
        return this.failedScenarios.size();
    }

    public void processSteps() {
        ArrayList<Step> allSteps = new ArrayList<Step>();
        StatusCounter stepsCounter = new StatusCounter();
        ArrayList<Scenario> passedScenarios = new ArrayList<Scenario>();
        ArrayList<Scenario> failedScenarios = new ArrayList<Scenario>();
        long totalDuration = 0L;
        if (this.elements != null) {
            for (Scenario element : this.elements) {
                this.calculateScenarioStats(passedScenarios, failedScenarios, element);
                if (!element.hasSteps()) continue;
                for (Step step : element.getSteps()) {
                    allSteps.add(step);
                    stepsCounter.incrementFor(step.getStatus());
                    totalDuration += step.getDuration();
                }
            }
        }
        this.passedScenarios = passedScenarios;
        this.failedScenarios = failedScenarios;
        this.stepResults = new StepResults(allSteps, stepsCounter, totalDuration);
    }

    private void calculateScenarioStats(List<Scenario> passedScenarios, List<Scenario> failedScenarios, Scenario element) {
        if (element.isScenario()) {
            if (element.getStatus() == Status.PASSED) {
                passedScenarios.add(element);
            } else if (element.getStatus() == Status.FAILED) {
                failedScenarios.add(element);
            }
        }
    }
}

