/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;

public class TagOverviewPage
extends AbstractPage {
    public TagOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "tagOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        this.contextMap.put("tags", (Object)this.reportInformation.getTags());
        this.contextMap.put("total_tags", (Object)this.reportInformation.getTags().size());
        this.contextMap.put("total_scenarios", (Object)this.reportInformation.getTotalTagScenarios());
        this.contextMap.put("total_passed_scenarios", (Object)this.reportInformation.getTotalTagScenariosPassed());
        this.contextMap.put("total_failed_scenarios", (Object)this.reportInformation.getTotalTagScenariosFailed());
        this.contextMap.put("total_steps", (Object)this.reportInformation.getTotalTagSteps());
        this.contextMap.put("total_passes", (Object)this.reportInformation.getTotalTagPasses());
        this.contextMap.put("total_fails", (Object)this.reportInformation.getTotalTagFails());
        this.contextMap.put("total_skipped", (Object)this.reportInformation.getTotalTagSkipped());
        this.contextMap.put("total_pending", (Object)this.reportInformation.getTotalTagPending());
        this.contextMap.put("total_undefined", (Object)this.reportInformation.getTotalTagUndefined());
        this.contextMap.put("total_missing", (Object)this.reportInformation.getTotalTagMissing());
        this.contextMap.put("hasCustomHeader", (Object)false);
        boolean flashCharts = this.reportBuilder.isFlashCharts();
        boolean highCharts = this.reportBuilder.isHighCharts();
        List<TagObject> tags = this.reportInformation.getTags();
        this.contextMap.put("backgrounds", (Object)this.reportInformation.getBackgroundInfo());
        if (flashCharts) {
            this.contextMap.put("chart_data", (Object)FlashChartBuilder.generateStackedColumnChart(tags));
        } else if (highCharts) {
            this.contextMap.put("chart_categories", (Object)JsChartUtil.getTags(tags));
            this.contextMap.put("chart_data", (Object)JsChartUtil.generateTagChartDataForHighCharts(tags));
        } else {
            this.contextMap.put("chart_rows", (Object)JsChartUtil.generateTagChartData(tags));
        }
        this.contextMap.put("total_duration", (Object)this.reportInformation.getTotalTagDuration());
        this.contextMap.put("flashCharts", (Object)flashCharts);
        this.contextMap.put("highCharts", (Object)highCharts);
        long durationl = this.reportInformation.getBackgroundInfo().getTotalDuration() + this.reportInformation.getLongTotalTagDuration();
        String duration = Util.formatDuration(durationl);
        this.contextMap.put("total_duration", (Object)duration);
        super.generateReport("tag-overview.html");
    }
}

