/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.generators.AbstractPage;

public class FeatureOverviewPage
extends AbstractPage {
    public FeatureOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "featureOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        this.contextMap.put("features", (Object)this.reportInformation.getFeatures());
        this.contextMap.put("parallel", (Object)ReportBuilder.isParallel());
        this.contextMap.put("total_features", (Object)this.reportInformation.getTotalFeatures());
        this.contextMap.put("total_steps", (Object)this.reportInformation.getTotalSteps());
        this.contextMap.put("total_passes", (Object)this.reportInformation.getTotalStepsPassed());
        this.contextMap.put("total_fails", (Object)this.reportInformation.getTotalStepsFailed());
        this.contextMap.put("total_skipped", (Object)this.reportInformation.getTotalStepsSkipped());
        this.contextMap.put("total_pending", (Object)this.reportInformation.getTotalStepsPending());
        this.contextMap.put("total_undefined", (Object)this.reportInformation.getTotalStepsUndefined());
        this.contextMap.put("total_missing", (Object)this.reportInformation.getTotalStepsMissing());
        this.contextMap.put("scenarios_passed", (Object)this.reportInformation.getTotalScenariosPassed());
        this.contextMap.put("scenarios_failed", (Object)this.reportInformation.getTotalScenariosFailed());
        this.contextMap.put("total_scenarios", (Object)this.reportInformation.getTotalScenarios());
        if (this.reportBuilder.isFlashCharts()) {
            this.contextMap.put("step_data", (Object)FlashChartBuilder.getStepsChart(this.reportInformation.getTotalStepsPassed(), this.reportInformation.getTotalStepsFailed(), this.reportInformation.getTotalStepsSkipped(), this.reportInformation.getTotalStepsPending(), this.reportInformation.getTotalStepsUndefined(), this.reportInformation.getTotalStepsMissing()));
            this.contextMap.put("scenario_data", (Object)FlashChartBuilder.pieScenariosChart(this.reportInformation.getTotalScenariosPassed(), this.reportInformation.getTotalScenariosFailed()));
        } else {
            JsChartUtil pie = new JsChartUtil();
            List<String> stepColours = pie.orderStepsByValue(this.reportInformation.getTotalStepsPassed(), this.reportInformation.getTotalStepsFailed(), this.reportInformation.getTotalStepsSkipped(), this.reportInformation.getTotalStepsPending(), this.reportInformation.getTotalStepsUndefined(), this.reportInformation.getTotalStepsMissing());
            this.contextMap.put("step_data", (Object)stepColours);
            List<String> scenarioColours = pie.orderScenariosByValue(this.reportInformation.getTotalScenariosPassed(), this.reportInformation.getTotalScenariosFailed());
            this.contextMap.put("scenario_data", (Object)scenarioColours);
        }
        this.contextMap.put("total_duration", (Object)this.reportInformation.getTotalDurationAsString());
        this.contextMap.put("flashCharts", (Object)this.reportBuilder.isFlashCharts());
        this.contextMap.put("highCharts", (Object)this.reportBuilder.isHighCharts());
        super.generateReport("feature-overview.html");
    }
}

