/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.Background;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.ScenarioTag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;

public class ReportInformation {
    private final Map<String, List<Feature>> featureMap;
    private final Map<String, StepObject> stepObjects = new HashMap<String, StepObject>();
    private List<Feature> features;
    private int numberOfScenarios;
    private int numberOfSteps;
    private final StatusCounter allStatuses = new StatusCounter();
    private final StatusCounter totalBackgroundSteps = new StatusCounter();
    private long totalDuration;
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private int totalTagScenarios;
    private int totalTagSteps;
    private final StatusCounter tagStatusCounter = new StatusCounter();
    private long totalTagDuration;
    private int totalPassingTagScenarios;
    private int totalFailingTagScenarios;
    private Background backgroundInfo = new Background();

    public ReportInformation(Map<String, List<Feature>> featureMap) {
        this.featureMap = featureMap;
        this.features = this.listAllFeatures();
        this.processFeatures();
        this.processTags();
        this.processSteps();
    }

    private List<Feature> listAllFeatures() {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> pairs : this.featureMap.entrySet()) {
            List<Feature> featureList = pairs.getValue();
            allFeatures.addAll(featureList);
        }
        return allFeatures;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<TagObject> getTags() {
        return new ArrayList<TagObject>(this.allTags.values());
    }

    public Map<String, List<Feature>> getFeatureMap() {
        return this.featureMap;
    }

    public Map<String, StepObject> getStepObject() {
        return this.stepObjects;
    }

    public int getTotalScenarios() {
        return this.numberOfScenarios;
    }

    public int getTotalFeatures() {
        return this.features.size();
    }

    public int getTotalSteps() {
        return this.numberOfSteps;
    }

    public int getTotalStepsPassed() {
        return this.allStatuses.getValueFor(Status.PASSED);
    }

    public int getTotalStepsFailed() {
        return this.allStatuses.getValueFor(Status.FAILED);
    }

    public int getTotalStepsSkipped() {
        return this.allStatuses.getValueFor(Status.SKIPPED);
    }

    public int getTotalStepsPending() {
        return this.allStatuses.getValueFor(Status.PENDING);
    }

    public int getTotalStepsMissing() {
        return this.allStatuses.getValueFor(Status.MISSING);
    }

    public int getTotalStepsUndefined() {
        return this.allStatuses.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public int getTotalTagScenarios() {
        return this.totalTagScenarios;
    }

    public int getTotalTagScenariosPassed() {
        return this.totalPassingTagScenarios;
    }

    public int getTotalTagScenariosFailed() {
        return this.totalFailingTagScenarios;
    }

    public int getTotalTagSteps() {
        return this.totalTagSteps;
    }

    public int getTotalTagPasses() {
        return this.tagStatusCounter.getValueFor(Status.PASSED);
    }

    public int getTotalTagFails() {
        return this.tagStatusCounter.getValueFor(Status.FAILED);
    }

    public int getTotalTagSkipped() {
        return this.tagStatusCounter.getValueFor(Status.SKIPPED);
    }

    public int getTotalTagPending() {
        return this.tagStatusCounter.getValueFor(Status.PENDING);
    }

    public int getTotalTagUndefined() {
        return this.tagStatusCounter.getValueFor(Status.UNDEFINED);
    }

    public int getTotalTagMissing() {
        return this.tagStatusCounter.getValueFor(Status.MISSING);
    }

    public String getTotalTagDuration() {
        return Util.formatDuration(this.totalTagDuration);
    }

    public long getLongTotalTagDuration() {
        return this.totalTagDuration;
    }

    public int getTotalScenariosPassed() {
        return this.totalBackgroundSteps.getValueFor(Status.PASSED);
    }

    public int getTotalScenariosFailed() {
        return this.totalBackgroundSteps.getValueFor(Status.FAILED);
    }

    private void processTags() {
        for (TagObject tag : this.allTags.values()) {
            this.countTagScenarios(tag);
            for (Status status : Status.values()) {
                this.tagStatusCounter.incrementFor(status, tag.getNumberOfStatus(status));
            }
            for (ScenarioTag scenarioTag : tag.getScenarios()) {
                Step[] steps;
                if (!scenarioTag.hasSteps()) continue;
                for (Step step : steps = scenarioTag.getScenario().getSteps()) {
                    this.totalTagDuration += step.getDuration();
                }
                this.totalTagSteps += steps.length;
            }
        }
    }

    private void countTagScenarios(TagObject tag) {
        for (ScenarioTag scenarioTag : tag.getScenarios()) {
            if (!scenarioTag.getScenario().isScenario()) continue;
            ++this.totalTagScenarios;
            if (scenarioTag.getScenario().getStatus() == Status.PASSED) {
                ++this.totalPassingTagScenarios;
                continue;
            }
            if (scenarioTag.getScenario().getStatus() != Status.FAILED) continue;
            ++this.totalFailingTagScenarios;
        }
    }

    private void processFeatures() {
        for (Feature feature : this.features) {
            ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
            Scenario[] allFeatureScenarios = feature.getScenarios();
            this.numberOfScenarios += this.countNoBackgroundScenarios(allFeatureScenarios);
            for (Scenario scenario : allFeatureScenarios) {
                if (!scenario.isScenario()) continue;
                scenarioTagList.add(new ScenarioTag(scenario, feature.getFileName()));
            }
            for (Scenario scenario : allFeatureScenarios) {
                if (scenario.isScenario()) {
                    this.totalBackgroundSteps.incrementFor(scenario.getStatus());
                } else {
                    this.updateBackgroundInfo(scenario);
                }
                this.addScenarioTagsToTagMap(scenario.getTags(), scenarioTagList);
                this.updateStepsForScenario(scenario);
            }
        }
    }

    private void processSteps() {
        for (Feature feature : this.features) {
            Scenario[] scenarios;
            for (Scenario scenario : scenarios = feature.getScenarios()) {
                this.countSteps(scenario.getBefore());
                this.countSteps(scenario.getAfter());
                this.countSteps(scenario.getSteps());
            }
        }
    }

    private void countSteps(ResultsWithMatch[] steps) {
        for (ResultsWithMatch step : steps) {
            StepObject stepObject;
            String methodName = null;
            Match match = step.getMatch();
            if (match != null) {
                methodName = match.getLocation();
            }
            if ((stepObject = this.stepObjects.get(methodName)) == null) {
                stepObject = new StepObject(methodName);
            }
            if (step.getResult() != null) {
                stepObject.addDuration(step.getResult().getDuration(), step.getResult().getStatus());
            } else {
                stepObject.addDuration(0L, Status.FAILED.name());
            }
            this.stepObjects.put(methodName, stepObject);
        }
    }

    private void updateBackgroundInfo(Scenario scenario) {
        this.backgroundInfo.incrTotalScenarios();
        if (scenario.getStatus() == Status.PASSED) {
            this.backgroundInfo.incPassedScenarios();
        } else {
            this.backgroundInfo.incFailedScenarios();
        }
        this.backgroundInfo.addTotalSteps(scenario.getSteps().length);
        for (Step step : scenario.getSteps()) {
            this.backgroundInfo.incrTotalDurationBy(step.getDuration());
            this.backgroundInfo.incrStepCounterForStatus(step.getStatus());
        }
    }

    private void updateStepsForScenario(Scenario scenario) {
        Step[] steps = scenario.getSteps();
        this.numberOfSteps += steps.length;
        for (Step step : steps) {
            this.allStatuses.incrementFor(step.getStatus());
            this.totalDuration += step.getDuration();
        }
    }

    private int countNoBackgroundScenarios(Scenario[] scenarios) {
        int counter = 0;
        for (Scenario scenario : scenarios) {
            if (!scenario.isScenario()) continue;
            ++counter;
        }
        return counter;
    }

    private void addScenarioUnlessExists(TagObject tagObject, ScenarioTag scenarioToAdd) {
        for (ScenarioTag scenarioTag : tagObject.getScenarios()) {
            if (!scenarioTag.getScenario().getId().equals(scenarioToAdd.getScenario().getId()) || !scenarioTag.getScenario().equals(scenarioToAdd.getScenario())) continue;
            return;
        }
        tagObject.addScenarios(scenarioToAdd);
    }

    private void addScenarioTagsToTagMap(Tag[] scenarioTagsAllScenarios, List<ScenarioTag> scenariosWithoutBackground) {
        for (Tag tag : scenarioTagsAllScenarios) {
            TagObject tagObject = this.addTagObject(tag.getName());
            block1: for (ScenarioTag scenarioTag : scenariosWithoutBackground) {
                for (Tag tag2 : scenarioTag.getScenario().getTags()) {
                    if (!tag2.getName().equals(tag.getName())) continue;
                    this.addScenarioUnlessExists(tagObject, scenarioTag);
                    continue block1;
                }
            }
        }
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getTagName(), tagObject);
        }
        return tagObject;
    }

    public Background getBackgroundInfo() {
        return this.backgroundInfo;
    }
}

