/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.util.HashMap;
import java.util.Map;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.util.Util;

public class Background {
    private final Map<Status, Integer> stepsCounter = new HashMap<Status, Integer>();
    private int totalScenarios;
    private int totalScenariosPassed;
    private int totalScenariosFailed;
    private int totalSteps;
    private long totalDuration;

    public Background() {
        for (Status status : Status.values()) {
            this.stepsCounter.put(status, 0);
        }
    }

    public int getTotalScenarios() {
        return this.totalScenarios;
    }

    public int incrTotalScenarios() {
        return this.totalScenarios++;
    }

    public int getTotalScenariosPassed() {
        return this.totalScenariosPassed;
    }

    public void incPassedScenarios() {
        ++this.totalScenariosPassed;
    }

    public int getTotalScenariosFailed() {
        return this.totalScenariosFailed;
    }

    public void incFailedScenarios() {
        ++this.totalScenariosFailed;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void addTotalSteps(int totalSteps) {
        this.totalSteps += totalSteps;
    }

    public int getTotalStepsPassed() {
        return this.getTotalStepsForStatus(Status.PASSED);
    }

    public int getTotalStepsFailed() {
        return this.getTotalStepsForStatus(Status.FAILED);
    }

    public int getTotalStepsSkipped() {
        return this.getTotalStepsForStatus(Status.SKIPPED);
    }

    public int getTotalStepsUndefined() {
        return this.getTotalStepsForStatus(Status.UNDEFINED);
    }

    public int getTotalStepsMissing() {
        return this.getTotalStepsForStatus(Status.MISSING);
    }

    public int getTotalStepsPending() {
        return this.getTotalStepsForStatus(Status.PENDING);
    }

    public void incrStepCounterForStatus(Status status) {
        Integer counter;
        Integer n = counter = this.stepsCounter.get((Object)status);
        Integer n2 = counter = Integer.valueOf(counter + 1);
        this.stepsCounter.put(status, counter);
    }

    public int getTotalStepsForStatus(Status status) {
        return this.stepsCounter.get((Object)status);
    }

    public String getTotalFormattedDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public void incrTotalDurationBy(Long totalDuration) {
        this.totalDuration += totalDuration.longValue();
    }
}

