/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import java.util.List;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.StatusCounter;
import net.masterthought.cucumber.util.Util;

public class StepResults {
    private final Step[] allSteps;
    private final StatusCounter statusCounter;
    private final long totalDuration;

    public StepResults(List<Step> allSteps, StatusCounter statusCounter, long totalDuration) {
        this.allSteps = new Step[allSteps.size()];
        allSteps.toArray(this.allSteps);
        this.statusCounter = statusCounter;
        this.totalDuration = totalDuration;
    }

    public int getNumberOfSteps() {
        return this.allSteps.length;
    }

    public int getNumberOfPasses() {
        return this.statusCounter.getValueFor(Status.PASSED);
    }

    public int getNumberOfFailures() {
        return this.statusCounter.getValueFor(Status.FAILED);
    }

    public int getNumberOfUndefined() {
        return this.statusCounter.getValueFor(Status.UNDEFINED);
    }

    public int getNumberOfPending() {
        return this.statusCounter.getValueFor(Status.PENDING);
    }

    public int getNumberOfSkipped() {
        return this.statusCounter.getValueFor(Status.SKIPPED);
    }

    public int getNumberOfMissing() {
        return this.statusCounter.getValueFor(Status.MISSING);
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }
}

