/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.ReportInformation;
import net.masterthought.cucumber.VelocityContextMap;
import net.masterthought.cucumber.generators.ErrorPage;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;

public abstract class AbstractPage {
    protected final VelocityEngine ve = new VelocityEngine();
    protected final VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
    private Template template;
    private final String fileName;
    protected final ReportBuilder reportBuilder;
    protected final ReportInformation reportInformation;

    protected AbstractPage(ReportBuilder reportBuilder, String fileName) {
        this.reportBuilder = reportBuilder;
        this.fileName = fileName;
        this.reportInformation = reportBuilder.getReportInformation();
    }

    public void generatePage() throws IOException {
        this.ve.init(this.getProperties());
        this.template = this.ve.getTemplate("templates/pages/" + this.fileName);
        this.contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
        this.contextMap.put("esc", (Object)new EscapeTool());
        if (this instanceof ErrorPage) {
            this.contextMap.put("time_stamp", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
        } else {
            this.contextMap.put("time_stamp", (Object)this.reportInformation.timeStamp());
        }
    }

    protected void generateReport(String fileName) throws IOException {
        VelocityContext context = this.contextMap.getVelocityContext();
        context.put("pageUrl", (Object)fileName);
        File dir = new File(this.reportBuilder.getReportDirectory(), fileName);
        try (FileOutputStream fileStream = new FileOutputStream(dir);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileStream, "UTF8"));){
            this.template.merge((Context)context, (Writer)writer);
        }
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.reportBuilder.getReportDirectory(), "velocity.log").getPath());
        return props;
    }

    protected Map<String, Object> getGeneralParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("version", "cucumber-reporting-0.4.0");
        result.put("fromJenkins", this.reportBuilder.isRunWithJenkins());
        result.put("jenkins_base", this.reportBuilder.getPluginUrlPath());
        result.put("build_project", this.reportBuilder.getBuildProject());
        result.put("build_number", this.reportBuilder.getBuildNumber());
        int previousBuildNumber = -1;
        try {
            previousBuildNumber = Integer.parseInt(this.reportBuilder.getBuildNumber());
            --previousBuildNumber;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        result.put("previous_build_number", previousBuildNumber);
        return result;
    }
}

