/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.Artifact;
import net.masterthought.cucumber.Background;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ScenarioTag;
import net.masterthought.cucumber.StepObject;
import net.masterthought.cucumber.TagObject;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.StatusCounter;
import net.masterthought.cucumber.util.Util;

public class ReportInformation {
    private final Map<String, List<Feature>> featureMap;
    private final Map<String, StepObject> stepObjects = new HashMap<String, StepObject>();
    private List<Feature> features;
    private int numberOfScenarios;
    private int numberOfSteps;
    private final StatusCounter totalSteps = new StatusCounter();
    private final StatusCounter totalBackgroundSteps = new StatusCounter();
    private Long totalDuration = 0L;
    private List<TagObject> allTags = new ArrayList<TagObject>();
    private int totalTagScenarios = 0;
    private int totalTagSteps = 0;
    private final StatusCounter totalTags = new StatusCounter();
    private long totalTagDuration = 0L;
    private int totalPassingTagScenarios = 0;
    private int totalFailingTagScenarios = 0;
    private Background backgroundInfo = new Background();

    public ReportInformation(Map<String, List<Feature>> featureMap) {
        this.featureMap = featureMap;
        this.features = this.listAllFeatures();
        this.processFeatures();
        this.processTags();
        this.processSteps();
    }

    private List<Feature> listAllFeatures() {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> pairs : this.featureMap.entrySet()) {
            List<Feature> featureList = pairs.getValue();
            allFeatures.addAll(featureList);
        }
        return allFeatures;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<TagObject> getTags() {
        return this.allTags;
    }

    public Map<String, List<Feature>> getFeatureMap() {
        return this.featureMap;
    }

    public Map<String, StepObject> getStepObject() {
        return this.stepObjects;
    }

    public int getTotalScenarios() {
        return this.numberOfScenarios;
    }

    public int getTotalFeatures() {
        return this.features.size();
    }

    public int getTotalSteps() {
        return this.numberOfSteps;
    }

    public int getTotalStepsPassed() {
        return this.totalSteps.getValueFor(Status.PASSED);
    }

    public int getTotalStepsFailed() {
        return this.totalSteps.getValueFor(Status.FAILED);
    }

    public int getTotalStepsSkipped() {
        return this.totalSteps.getValueFor(Status.SKIPPED);
    }

    public int getTotalStepsPending() {
        return this.totalSteps.getValueFor(Status.PENDING);
    }

    public int getTotalStepsMissing() {
        return this.totalSteps.getValueFor(Status.MISSING);
    }

    public int getTotalStepsUndefined() {
        return this.totalSteps.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public String getReportStatusColour(Feature feature) {
        return feature.getStatus() == Status.PASSED ? Status.PASSED.color : Status.FAILED.color;
    }

    public String getTagReportStatusColour(TagObject tag) {
        return tag.getStatus() == Status.PASSED ? Status.PASSED.color : Status.FAILED.color;
    }

    public int getTotalTags() {
        return this.allTags.size();
    }

    public int getTotalTagScenarios() {
        return this.totalTagScenarios;
    }

    public List<TagObject> getTagList() {
        return this.allTags;
    }

    public int getTotalTagScenariosPassed() {
        return this.totalPassingTagScenarios;
    }

    public int getTotalTagScenariosFailed() {
        return this.totalFailingTagScenarios;
    }

    public int getTotalTagSteps() {
        return this.totalTagSteps;
    }

    public int getTotalTagPasses() {
        return this.totalTags.getValueFor(Status.PASSED);
    }

    public int getTotalTagFails() {
        return this.totalTags.getValueFor(Status.FAILED);
    }

    public int getTotalTagSkipped() {
        return this.totalTags.getValueFor(Status.SKIPPED);
    }

    public int getTotalTagPending() {
        return this.totalTags.getValueFor(Status.PENDING);
    }

    public int getTotalTagUndefined() {
        return this.totalTags.getValueFor(Status.UNDEFINED);
    }

    public int getTotalTagMissing() {
        return this.totalTags.getValueFor(Status.MISSING);
    }

    public String getTotalTagDuration() {
        return Util.formatDuration(this.totalTagDuration);
    }

    public long getLongTotalTagDuration() {
        return this.totalTagDuration;
    }

    public int getTotalScenariosPassed() {
        return this.totalBackgroundSteps.getValueFor(Status.PASSED);
    }

    public int getTotalScenariosFailed() {
        return this.totalBackgroundSteps.getValueFor(Status.FAILED);
    }

    private void processTags() {
        for (TagObject tag : this.allTags) {
            this.totalTagScenarios = this.calculateTotalTagScenarios(tag);
            this.totalPassingTagScenarios = this.calculateTotalTagScenariosForStatus(this.totalPassingTagScenarios, tag, Status.PASSED);
            this.totalFailingTagScenarios = this.calculateTotalTagScenariosForStatus(this.totalFailingTagScenarios, tag, Status.FAILED);
            for (Status status : Status.values()) {
                this.totalTags.incrementFor(status, tag.getNumberOfStatus(status));
            }
            for (ScenarioTag scenarioTag : tag.getScenarios()) {
                Step[] steps;
                if (!scenarioTag.hasSteps()) continue;
                for (Step step : steps = scenarioTag.getScenario().getSteps()) {
                    this.totalTagDuration += step.getDuration();
                }
                this.totalTagSteps += steps.length;
            }
        }
    }

    private int calculateTotalTagScenariosForStatus(int totalScenarios, TagObject tag, Status status) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : tag.getScenarios()) {
            if (scenarioTag.getScenario().isBackground() || !scenarioTag.getScenario().getStatus().equals((Object)status)) continue;
            scenarioTagList.add(scenarioTag);
        }
        return totalScenarios + scenarioTagList.size();
    }

    private int calculateTotalTagScenarios(TagObject tag) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : tag.getScenarios()) {
            if (scenarioTag.getScenario().isBackground()) continue;
            scenarioTagList.add(scenarioTag);
        }
        return this.totalTagScenarios + scenarioTagList.size();
    }

    private void processFeatures() {
        for (Feature feature : this.features) {
            ArrayList<ScenarioTag> scenarioList = new ArrayList<ScenarioTag>();
            Element[] scenarios = feature.getElements();
            this.numberOfScenarios = this.getNumberOfScenarios(scenarios);
            if (feature.hasTags()) {
                for (Element e : feature.getElements()) {
                    if (e.isBackground()) continue;
                    scenarioList.add(new ScenarioTag(e, feature.getFileName()));
                }
                this.addToTagMapByFeature(feature.getTags(), scenarioList);
            }
            for (Element scenario : scenarios) {
                if (!scenario.isBackground()) {
                    this.totalBackgroundSteps.incrementFor(scenario.getStatus());
                } else {
                    this.setBackgroundInfo(scenario);
                }
                if (scenario.hasTags()) {
                    this.addScenarioUnlessExists(scenarioList, new ScenarioTag(scenario, feature.getFileName()));
                    this.addToTagMap(scenario.getTags(), scenarioList);
                }
                this.adjustStepsForScenario(scenario);
            }
        }
    }

    private void processSteps() {
        for (Feature feature : this.features) {
            Element[] scenarios;
            for (Element scenario : scenarios = feature.getElements()) {
                this.countSteps(scenario.getBefore());
                this.countSteps(scenario.getAfter());
                this.countSteps(scenario.getSteps());
            }
        }
    }

    private void countSteps(ResultsWithMatch[] steps) {
        if (steps != null) {
            for (ResultsWithMatch step : steps) {
                StepObject stepObject;
                String methodName = null;
                Match match = step.getMatch();
                if (match != null) {
                    methodName = match.getLocation();
                }
                if ((stepObject = this.stepObjects.get(methodName)) == null) {
                    stepObject = new StepObject(methodName);
                }
                if (step.getResult() != null) {
                    stepObject.addDuration(step.getResult().getDuration(), step.getResult().getStatus());
                } else {
                    stepObject.addDuration(0L, Status.FAILED.name());
                }
                this.stepObjects.put(methodName, stepObject);
            }
        }
    }

    private void setBackgroundInfo(Element e) {
        this.backgroundInfo.addTotalScenarios(1);
        if (e.getStatus() == Status.PASSED) {
            this.backgroundInfo.addTotalScenariosPassed(1);
        } else {
            this.backgroundInfo.addTotalScenariosFailed(1);
        }
        this.backgroundInfo.addTotalSteps(e.getSteps().length);
        for (Step step : e.getSteps()) {
            this.backgroundInfo.incrTotalDurationBy(step.getDuration());
            this.backgroundInfo.incrStepCounterForStatus(step.getStatus());
        }
    }

    private void adjustStepsForScenario(Element element) {
        String scenarioName = element.getRawName();
        if (element.hasSteps()) {
            Step[] steps = element.getSteps();
            this.numberOfSteps += steps.length;
            for (Step step : steps) {
                String mapKey;
                Map<String, Artifact> map;
                String stepName = step.getRawName();
                ConfigurationOptions configuration = ConfigurationOptions.instance();
                if (configuration.artifactsEnabled() && (map = configuration.artifactConfig()).containsKey(mapKey = scenarioName + stepName)) {
                    Artifact artifact = map.get(mapKey);
                    String keyword = artifact.getKeyword();
                    String contentType = artifact.getContentType();
                    step.setName(stepName.replaceFirst(keyword, this.getArtifactFile(mapKey, keyword, artifact.getArtifactFile(), contentType)));
                }
                this.totalSteps.incrementFor(step.getStatus());
                this.totalDuration = this.totalDuration + step.getDuration();
            }
        }
    }

    private int getNumberOfScenarios(Element[] scenarios) {
        for (Element scenario : scenarios) {
            if (scenario.isBackground()) continue;
            ++this.numberOfScenarios;
        }
        return this.numberOfScenarios;
    }

    private String getArtifactFile(String mapKey, String keyword, String artifactFile, String contentType) {
        mapKey = mapKey.replaceAll(" ", "_");
        String link = "";
        link = contentType.equals("xml") ? "<div style=\"display:none;\"><textarea id=\"" + mapKey + "\" class=\"brush: xml;\"></textarea></div><a onclick=\"applyArtifact('" + mapKey + "','" + artifactFile + "')\" href=\"#\">" + keyword + "</a>" : "<div style=\"display:none;\"><textarea id=\"" + mapKey + "\"></textarea></div><script>\\$('#" + mapKey + "').load('" + artifactFile + "')</script><a onclick=\"\\$('#" + mapKey + "').dialog();\" href=\"#\">" + keyword + "</a>";
        return link;
    }

    private void addScenarioUnlessExists(List<ScenarioTag> scenarioList, ScenarioTag scenarioToAdd) {
        for (ScenarioTag scenario : scenarioList) {
            if (!scenario.getParentFeatureUri().equalsIgnoreCase(scenarioToAdd.getParentFeatureUri()) || !scenario.getScenario().equals(scenarioToAdd.getScenario())) continue;
            return;
        }
        scenarioList.add(scenarioToAdd);
    }

    private void addToTagMap(Tag[] tagList, List<ScenarioTag> scenarioList) {
        for (Tag tag : tagList) {
            TagObject tagObj = this.findTagObjectByNameInList(tag.getName(), this.allTags);
            ArrayList<ScenarioTag> existingTagList = new ArrayList<ScenarioTag>();
            if (tagObj == null) {
                tagObj = new TagObject(tag.getName(), existingTagList);
            } else {
                existingTagList.addAll(tagObj.getScenarios());
                tagObj.setScenarios(existingTagList);
                this.allTags.remove(tagObj);
            }
            block1: for (ScenarioTag scenarioTag : scenarioList) {
                for (Tag tag2 : scenarioTag.getScenario().getTags()) {
                    if (!tag2.getName().equals(tag.getName())) continue;
                    this.addScenarioUnlessExists(existingTagList, scenarioTag);
                    continue block1;
                }
            }
            this.allTags.add(tagObj);
        }
    }

    public void addToTagMapByFeature(Tag[] tagList, List<ScenarioTag> scenarioList) {
        for (Tag tag : tagList) {
            TagObject tagObj = this.findTagObjectByNameInList(tag.getName(), this.allTags);
            if (tagObj != null) {
                ArrayList<ScenarioTag> allScenarios = new ArrayList<ScenarioTag>();
                allScenarios.addAll(tagObj.getScenarios());
                allScenarios.addAll(scenarioList);
                this.allTags.remove(tagObj);
                tagObj.setScenarios(allScenarios);
            } else {
                tagObj = new TagObject(tag.getName(), scenarioList);
            }
            this.allTags.add(tagObj);
        }
    }

    private TagObject findTagObjectByNameInList(String name, List<TagObject> list) {
        for (TagObject tagObject : list) {
            if (!tagObject.getTagName().equalsIgnoreCase(name)) continue;
            return tagObject;
        }
        return null;
    }

    public Background getBackgroundInfo() {
        return this.backgroundInfo;
    }
}

