/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class UnzipUtils {
    private static final int BUFFER_SIZE = 2048;
    private static final String ZIP_EXTENSION = ".zip";

    public static void unzipToFile(File srcZipFile, File destDirectory) {
        try {
            destDirectory.mkdirs();
            try (ZipFile zipFile = new ZipFile(srcZipFile, 1);){
                Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
                while (zipFileEntries.hasMoreElements()) {
                    ZipEntry entry = zipFileEntries.nextElement();
                    File destFile = new File(destDirectory, entry.getName());
                    File parentDestFile = destFile.getParentFile();
                    parentDestFile.mkdirs();
                    if (entry.isDirectory()) continue;
                    BufferedInputStream bufIS = new BufferedInputStream(zipFile.getInputStream(entry));
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream bufOS = new BufferedOutputStream(new FileOutputStream(destFile), 2048);){
                            IOUtils.copy((InputStream)bufIS, (OutputStream)bufOS);
                        }
                        if (!entry.getName().toLowerCase().endsWith(ZIP_EXTENSION)) continue;
                        String zipFilePath = destDirectory.getPath() + File.separatorChar + entry.getName();
                        UnzipUtils.unzipToFile(new File(zipFilePath), new File(zipFilePath.substring(0, zipFilePath.length() - ZIP_EXTENSION.length())));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufIS == null) continue;
                        if (throwable != null) {
                            try {
                                bufIS.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        bufIS.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

