/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.MalformedJsonException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.json.Feature;
import org.apache.commons.io.FileUtils;

public class ReportParser {
    private final Map<String, List<Feature>> jsonReportFiles;

    public ReportParser(List<String> jsonReportFiles) throws IOException, JsonSyntaxException {
        this.jsonReportFiles = this.parseJsonResults(jsonReportFiles);
    }

    public Map<String, List<Feature>> getFeatures() {
        return this.jsonReportFiles;
    }

    private Map<String, List<Feature>> parseJsonResults(List<String> jsonReportFiles) throws IOException, JsonSyntaxException {
        LinkedHashMap<String, List<Feature>> featureResults = new LinkedHashMap<String, List<Feature>>();
        for (String jsonFile : jsonReportFiles) {
            if (FileUtils.sizeOf((File)new File(jsonFile)) <= 0L) continue;
            try {
                Feature[] features = (Feature[])new Gson().fromJson((Reader)new FileReader(jsonFile), Feature[].class);
                featureResults.put(jsonFile, Arrays.asList(features));
            }
            catch (JsonSyntaxException e) {
                System.out.println("[WARNING] File " + jsonFile + " is not a valid json report:  " + e.getMessage());
                if (!(e.getCause() instanceof MalformedJsonException)) continue;
                throw e;
            }
        }
        return featureResults;
    }
}

