/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.masterthought.cucumber.ArtifactProcessor;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ReportInformation;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.TagObject;
import net.masterthought.cucumber.VelocityContextMap;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.UnzipUtils;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;

public class ReportBuilder {
    ReportInformation ri;
    private File reportDirectory;
    private String buildNumber;
    private String buildProject;
    private String pluginUrlPath;
    private boolean flashCharts;
    private boolean runWithJenkins;
    private boolean artifactsEnabled;
    private boolean highCharts;
    private boolean parsingError;
    private static boolean parallel = false;
    private Map<String, String> customHeader;
    private final String VERSION = "cucumber-reporting-0.0.23";

    public static boolean isParallel() {
        return parallel;
    }

    public static void setParallel(boolean p) {
        parallel = p;
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public ReportBuilder(List<String> jsonReports, File reportDirectory, String pluginUrlPath, String buildNumber, String buildProject, boolean skippedFails, boolean undefinedFails, boolean flashCharts, boolean runWithJenkins, boolean artifactsEnabled, String artifactConfig, boolean highCharts) throws Exception {
        try {
            this.reportDirectory = reportDirectory;
            this.buildNumber = buildNumber;
            this.buildProject = buildProject;
            this.pluginUrlPath = this.getPluginUrlPath(pluginUrlPath);
            this.flashCharts = flashCharts;
            this.runWithJenkins = runWithJenkins;
            this.artifactsEnabled = artifactsEnabled;
            this.highCharts = highCharts;
            parallel = false;
            ConfigurationOptions.setSkippedFailsBuild(skippedFails);
            ConfigurationOptions.setUndefinedFailsBuild(undefinedFails);
            ConfigurationOptions.setArtifactsEnabled(artifactsEnabled);
            if (artifactsEnabled) {
                ArtifactProcessor artifactProcessor = new ArtifactProcessor(artifactConfig);
                ConfigurationOptions.setArtifactConfiguration(artifactProcessor.process());
            }
            ReportParser reportParser = new ReportParser(jsonReports);
            this.ri = new ReportInformation(reportParser.getFeatures());
        }
        catch (Exception exception) {
            this.parsingError = true;
            this.generateErrorPage(exception);
            System.out.println(exception);
        }
    }

    public ReportBuilder(List<String> jsonReports, File reportDirectory, String pluginUrlPath, String buildNumber, String buildProject, boolean skippedFails, boolean undefinedFails, boolean flashCharts, boolean runWithJenkins, boolean artifactsEnabled, String artifactConfig, boolean highCharts, boolean parallelTesting) throws Exception {
        try {
            this.reportDirectory = reportDirectory;
            this.buildNumber = buildNumber;
            this.buildProject = buildProject;
            this.pluginUrlPath = this.getPluginUrlPath(pluginUrlPath);
            this.flashCharts = flashCharts;
            this.runWithJenkins = runWithJenkins;
            this.artifactsEnabled = artifactsEnabled;
            this.highCharts = highCharts;
            parallel = parallelTesting;
            ConfigurationOptions.setSkippedFailsBuild(skippedFails);
            ConfigurationOptions.setUndefinedFailsBuild(undefinedFails);
            ConfigurationOptions.setArtifactsEnabled(artifactsEnabled);
            if (artifactsEnabled) {
                ArtifactProcessor artifactProcessor = new ArtifactProcessor(artifactConfig);
                ConfigurationOptions.setArtifactConfiguration(artifactProcessor.process());
            }
            ReportParser reportParser = new ReportParser(jsonReports);
            this.ri = new ReportInformation(reportParser.getFeatures());
        }
        catch (Exception exception) {
            this.parsingError = true;
            this.generateErrorPage(exception);
            System.out.println(exception);
        }
    }

    public boolean getBuildStatus() {
        return this.ri.getTotalNumberFailingSteps() <= 0;
    }

    public void generateReports() throws Exception {
        block5: {
            try {
                this.copyResource("themes", "blue.zip");
                if (this.flashCharts) {
                    this.copyResource("charts", "flash_charts.zip");
                } else {
                    this.copyResource("charts", "js.zip");
                }
                if (this.artifactsEnabled) {
                    this.copyResource("charts", "codemirror.zip");
                }
                this.setJsonFilesInFeatures();
                this.generateFeatureOverview();
                this.generateFeatureReports();
                this.generateTagReports();
                this.generateTagOverview();
            }
            catch (Exception exception) {
                if (this.parsingError) break block5;
                this.generateErrorPage(exception);
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    private void setJsonFilesInFeatures() throws Exception {
        for (Map.Entry<String, List<Feature>> pairs : this.ri.getProjectFeatureMap().entrySet()) {
            List<Feature> featureList = pairs.getValue();
            for (Feature feature : featureList) {
                String jsonFile = pairs.getKey().split("/")[pairs.getKey().split("/").length - 1];
                feature.setJsonFile(jsonFile);
            }
        }
    }

    public void generateFeatureReports() throws Exception {
        for (Map.Entry<String, List<Feature>> pairs : this.ri.getProjectFeatureMap().entrySet()) {
            List<Feature> featureList = pairs.getValue();
            for (Feature feature : featureList) {
                VelocityEngine ve = new VelocityEngine();
                ve.init(this.getProperties());
                Template featureResult = ve.getTemplate("templates/featureReport.vm");
                VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
                contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
                contextMap.put("parallel", (Object)ReportBuilder.isParallel());
                contextMap.put("feature", (Object)feature);
                contextMap.put("report_status_colour", (Object)this.ri.getReportStatusColour(feature));
                contextMap.put("scenarios", (Object)feature.getElements().toList());
                contextMap.put("time_stamp", (Object)this.ri.timeStamp());
                contextMap.put("artifactsEnabled", (Object)ConfigurationOptions.artifactsEnabled());
                contextMap.put("esc", (Object)new EscapeTool());
                this.generateReport(feature.getFileName(), featureResult, contextMap.getVelocityContext());
            }
        }
    }

    private void generateFeatureOverview() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template featureOverview = ve.getTemplate("templates/featureOverview.vm");
        VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
        contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
        contextMap.put("features", (Object)this.ri.getFeatures());
        contextMap.put("parallel", (Object)ReportBuilder.isParallel());
        contextMap.put("total_features", (Object)this.ri.getTotalNumberOfFeatures());
        contextMap.put("total_scenarios", (Object)this.ri.getTotalNumberOfScenarios());
        contextMap.put("total_steps", (Object)this.ri.getTotalNumberOfSteps());
        contextMap.put("total_passes", (Object)this.ri.getTotalNumberPassingSteps());
        contextMap.put("total_fails", (Object)this.ri.getTotalNumberFailingSteps());
        contextMap.put("total_skipped", (Object)this.ri.getTotalNumberSkippedSteps());
        contextMap.put("total_pending", (Object)this.ri.getTotalNumberPendingSteps());
        contextMap.put("scenarios_passed", (Object)this.ri.getTotalScenariosPassed());
        contextMap.put("scenarios_failed", (Object)this.ri.getTotalScenariosFailed());
        if (this.flashCharts) {
            contextMap.put("step_data", (Object)FlashChartBuilder.donutChart(this.ri.getTotalNumberPassingSteps(), this.ri.getTotalNumberFailingSteps(), this.ri.getTotalNumberSkippedSteps(), this.ri.getTotalNumberPendingSteps()));
            contextMap.put("scenario_data", (Object)FlashChartBuilder.pieChart(this.ri.getTotalScenariosPassed(), this.ri.getTotalScenariosFailed()));
        } else {
            JsChartUtil pie = new JsChartUtil();
            List<String> stepColours = pie.orderStepsByValue(this.ri.getTotalNumberPassingSteps(), this.ri.getTotalNumberFailingSteps(), this.ri.getTotalNumberSkippedSteps(), this.ri.getTotalNumberPendingSteps());
            contextMap.put("step_data", (Object)stepColours);
            List<String> scenarioColours = pie.orderScenariosByValue(this.ri.getTotalScenariosPassed(), this.ri.getTotalScenariosFailed());
            contextMap.put("scenario_data", (Object)scenarioColours);
        }
        contextMap.put("time_stamp", (Object)this.ri.timeStamp());
        contextMap.put("total_duration", (Object)this.ri.getTotalDurationAsString());
        contextMap.put("flashCharts", (Object)this.flashCharts);
        contextMap.put("highCharts", (Object)this.highCharts);
        this.generateReport("feature-overview.html", featureOverview, contextMap.getVelocityContext());
    }

    public void generateTagReports() throws Exception {
        for (TagObject tagObject : this.ri.getTags()) {
            VelocityEngine ve = new VelocityEngine();
            ve.init(this.getProperties());
            Template featureResult = ve.getTemplate("templates/tagReport.vm");
            VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
            contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
            contextMap.put("tag", (Object)tagObject);
            contextMap.put("time_stamp", (Object)this.ri.timeStamp());
            contextMap.put("report_status_colour", (Object)this.ri.getTagReportStatusColour(tagObject));
            this.generateReport(tagObject.getTagName().replace("@", "").trim() + ".html", featureResult, contextMap.getVelocityContext());
            contextMap.put("hasCustomHeader", (Object)false);
            if (this.customHeader == null || this.customHeader.get(tagObject.getTagName()) == null) continue;
            contextMap.put("hasCustomHeader", (Object)true);
            contextMap.put("customHeader", (Object)this.customHeader.get(tagObject.getTagName()));
        }
    }

    public void generateTagOverview() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template featureOverview = ve.getTemplate("templates/tagOverview.vm");
        VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
        contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
        contextMap.put("tags", (Object)this.ri.getTags());
        contextMap.put("total_tags", (Object)this.ri.getTotalTags());
        contextMap.put("total_scenarios", (Object)this.ri.getTotalTagScenarios());
        contextMap.put("total_passed_scenarios", (Object)this.ri.getTotalPassingTagScenarios());
        contextMap.put("total_failed_scenarios", (Object)this.ri.getTotalFailingTagScenarios());
        contextMap.put("total_steps", (Object)this.ri.getTotalTagSteps());
        contextMap.put("total_passes", (Object)this.ri.getTotalTagPasses());
        contextMap.put("total_fails", (Object)this.ri.getTotalTagFails());
        contextMap.put("total_skipped", (Object)this.ri.getTotalTagSkipped());
        contextMap.put("total_pending", (Object)this.ri.getTotalTagPending());
        contextMap.put("hasCustomHeaders", (Object)false);
        if (this.customHeader != null) {
            contextMap.put("hasCustomHeaders", (Object)true);
            contextMap.put("customHeaders", (Object)this.customHeader);
        }
        contextMap.put("backgrounds", (Object)this.ri.getBackgroundInfo());
        if (this.flashCharts) {
            contextMap.put("chart_data", (Object)FlashChartBuilder.StackedColumnChart(this.ri.tagMap));
        } else if (this.highCharts) {
            contextMap.put("chart_categories", (Object)JsChartUtil.getTags(this.ri.tagMap));
            contextMap.put("chart_data", (Object)JsChartUtil.generateTagChartDataForHighCharts(this.ri.tagMap));
        } else {
            contextMap.put("chart_rows", (Object)JsChartUtil.generateTagChartData(this.ri.tagMap));
        }
        contextMap.put("total_duration", (Object)this.ri.getTotalTagDuration());
        contextMap.put("time_stamp", (Object)this.ri.timeStamp());
        contextMap.put("flashCharts", (Object)this.flashCharts);
        contextMap.put("highCharts", (Object)this.highCharts);
        long durationl = this.ri.getBackgroundInfo().getTotalDuration() + this.ri.getLongTotalTagDuration();
        String duration = Util.formatDuration(durationl);
        contextMap.put("total_duration", (Object)duration);
        this.generateReport("tag-overview.html", featureOverview, contextMap.getVelocityContext());
    }

    public void generateErrorPage(Exception exception) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template errorPage = ve.getTemplate("templates/errorPage.vm");
        VelocityContextMap contextMap = VelocityContextMap.of(new VelocityContext());
        contextMap.putAll((Map<? extends String, ?>)this.getGeneralParameters());
        contextMap.put("error_message", (Object)exception);
        contextMap.put("time_stamp", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
        this.generateReport("feature-overview.html", errorPage, contextMap.getVelocityContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resourceLocation, String resourceName) throws IOException, URISyntaxException {
        File tmpResourcesArchive = File.createTempFile("temp", resourceName + ".zip");
        InputStream resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream(resourceLocation + "/" + resourceName);
        if (resourceArchiveInputStream == null) {
            resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream("/" + resourceLocation + "/" + resourceName);
        }
        FileOutputStream resourceArchiveOutputStream = new FileOutputStream(tmpResourcesArchive);
        try {
            IOUtils.copy((InputStream)resourceArchiveInputStream, (OutputStream)resourceArchiveOutputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceArchiveInputStream);
            IOUtils.closeQuietly((OutputStream)resourceArchiveOutputStream);
        }
        UnzipUtils.unzipToFile(tmpResourcesArchive, this.reportDirectory);
        FileUtils.deleteQuietly((File)tmpResourcesArchive);
    }

    private String getPluginUrlPath(String path) {
        return path.isEmpty() ? "/" : path;
    }

    private void generateReport(String fileName, Template featureResult, VelocityContext context) throws Exception {
        FileOutputStream fileStream = new FileOutputStream(new File(this.reportDirectory, fileName));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileStream, "UTF-8"));
        featureResult.merge((Context)context, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.reportDirectory, "velocity.log").getPath());
        return props;
    }

    private HashMap<String, Object> getGeneralParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("version", "cucumber-reporting-0.0.23");
        result.put("fromJenkins", this.runWithJenkins);
        result.put("jenkins_base", this.pluginUrlPath);
        result.put("build_project", this.buildProject);
        result.put("build_number", this.buildNumber);
        return result;
    }
}

