/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.VelocityContext;

public final class VelocityContextMap
implements Map<String, Object> {
    private final VelocityContext velocityContext;

    private VelocityContextMap(VelocityContext velocityContext) {
        this.velocityContext = velocityContext;
    }

    public static VelocityContextMap of(VelocityContext velocityContext) {
        return new VelocityContextMap(velocityContext);
    }

    @Override
    public int size() {
        return this.velocityContext.getKeys().length;
    }

    @Override
    public boolean isEmpty() {
        return this.velocityContext.getKeys().length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.velocityContext.containsKey(key);
    }

    @Override
    public boolean containsValue(Object searchFor) {
        for (String key : this.keySet()) {
            Object found = this.velocityContext.get(key);
            if (!searchFor.equals(found)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        return this.velocityContext.get((String)key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.velocityContext.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.velocityContext.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.velocityContext.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (Object key : this.velocityContext.getKeys()) {
            this.velocityContext.remove(key);
        }
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<Object>(Arrays.asList(this.velocityContext.getKeys()));
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> result = new HashSet<Object>();
        for (String key : this.keySet()) {
            result.add(this.velocityContext.get(key));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (String key : this.keySet()) {
            result.add(new AbstractMap.SimpleEntry<String, Object>(key, this.velocityContext.get(key)));
        }
        return result;
    }

    public VelocityContext getVelocityContext() {
        return this.velocityContext;
    }
}

