/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ScenarioTag;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.util.Util;

public class TagObject {
    private String tagName;
    private List<ScenarioTag> scenarios = new ArrayList<ScenarioTag>();
    private List<Element> elements = new ArrayList<Element>();

    public String getTagName() {
        return this.tagName;
    }

    public String getFileName() {
        return this.tagName.replace("@", "").trim() + ".html";
    }

    public List<ScenarioTag> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(List<ScenarioTag> scenarioTagList) {
        this.scenarios = scenarioTagList;
    }

    public TagObject(String tagName, List<ScenarioTag> scenarios) {
        this.tagName = tagName;
        this.scenarios = scenarios;
    }

    private void populateElements() {
        for (ScenarioTag scenarioTag : this.scenarios) {
            this.elements.add(scenarioTag.getScenario());
        }
    }

    public Integer getNumberOfScenarios() {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (scenarioTag.getScenario().getKeyword().equals("Background")) continue;
            scenarioTagList.add(scenarioTag);
        }
        return scenarioTagList.size();
    }

    public Integer getNumberOfPassingScenarios() {
        return this.getNumberOfScenariosForStatus(Util.Status.PASSED);
    }

    public Integer getNumberOfFailingScenarios() {
        return this.getNumberOfScenariosForStatus(Util.Status.FAILED);
    }

    private Integer getNumberOfScenariosForStatus(Util.Status status) {
        ArrayList<ScenarioTag> scenarioTagList = new ArrayList<ScenarioTag>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (scenarioTag.getScenario().getKeyword().equals("Background") || !scenarioTag.getScenario().getStatus().equals((Object)status)) continue;
            scenarioTagList.add(scenarioTag);
        }
        return scenarioTagList.size();
    }

    public String getDurationOfSteps() {
        Long duration = 0L;
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (!Util.hasSteps(scenarioTag)) continue;
            for (Step step : scenarioTag.getScenario().getSteps()) {
                duration = duration + step.getDuration();
            }
        }
        return Util.formatDuration(duration);
    }

    public int getNumberOfSteps() {
        int totalSteps = 0;
        for (ScenarioTag scenario : this.scenarios) {
            if (!Util.hasSteps(scenario)) continue;
            totalSteps += scenario.getScenario().getSteps().size();
        }
        return totalSteps;
    }

    public int getNumberOfPasses() {
        return Util.findStatusCount(this.getStatuses(), Util.Status.PASSED);
    }

    public int getNumberOfFailures() {
        return Util.findStatusCount(this.getStatuses(), Util.Status.FAILED);
    }

    public int getNumberOfSkipped() {
        return Util.findStatusCount(this.getStatuses(), Util.Status.SKIPPED);
    }

    public int getNumberOfPending() {
        return Util.findStatusCount(this.getStatuses(), Util.Status.UNDEFINED);
    }

    private List<Util.Status> getStatuses() {
        ArrayList<Util.Status> statuses = new ArrayList<Util.Status>();
        for (ScenarioTag scenarioTag : this.scenarios) {
            if (!Util.hasSteps(scenarioTag)) continue;
            for (Step step : scenarioTag.getScenario().getSteps()) {
                statuses.add(step.getStatus());
            }
        }
        return statuses;
    }

    public Sequence<Element> getElements() {
        this.populateElements();
        return Sequences.sequence(this.elements);
    }

    public Util.Status getStatus() {
        Sequence results = this.getElements().map(Element.functions.status());
        return results.contains((Object)Util.Status.FAILED) ? Util.Status.FAILED : Util.Status.PASSED;
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }
}

