/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.util.HashMap;
import java.util.Map;
import net.masterthought.cucumber.json.Artifact;

public class ArtifactProcessor {
    private String configuration;

    public ArtifactProcessor(String configuration) {
        this.configuration = configuration;
    }

    public Map<String, Artifact> process() throws Exception {
        String[] lines;
        HashMap<String, Artifact> map = new HashMap<String, Artifact>();
        for (String line : lines = this.configuration.split("\\n")) {
            String[] data = line.split("~");
            if (data.length != 5) {
                throw new Exception("Error configuration should have 5 parts: Scenario ~ Step ~ Keyword ~ Artifact File ~ ContentType");
            }
            String scenario = data[0].trim();
            String step = data[1].trim();
            String keyword = data[2].trim();
            String artifactFile = data[3].trim();
            String contentType = data[4].trim();
            map.put(scenario + step, new Artifact(scenario, step, keyword, artifactFile, contentType));
        }
        return map;
    }
}

