/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.common.base.Joiner;
import com.google.gson.internal.StringMap;
import com.googlecode.totallylazy.Function1;
import com.googlecode.totallylazy.Option;
import com.googlecode.totallylazy.Sequences;
import com.googlecode.totallylazy.predicates.LogicalPredicate;
import java.util.List;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.util.Util;
import org.joda.time.DateTime;

public class Step {
    private String name;
    private String keyword;
    private String line;
    private Result result;
    private Row[] rows;
    private Match match;
    private Object[] embeddings;
    private String[] output;

    public Row[] getRows() {
        return this.rows;
    }

    public String getOutput() {
        List outputList = Sequences.sequence((Object[])((Object[])Option.option((Object)this.output).getOrElse((Object)new String[0]))).realise().toList();
        return Joiner.on((String)"").skipNulls().join((Iterable)outputList);
    }

    public Match getMatch() {
        return this.match;
    }

    public Object[] getEmbeddings() {
        return this.embeddings;
    }

    public boolean hasRows() {
        boolean result = false;
        if (this.rows != null && this.rows.length > 0) {
            result = true;
        }
        return result;
    }

    private Util.Status getInternalStatus() {
        if (this.result == null) {
            System.out.println("[WARNING] Line " + this.line + " : " + "Step is missing Result: " + this.keyword + " : " + this.name);
            return Util.Status.MISSING;
        }
        return Util.resultMap.get(this.result.getStatus());
    }

    public Util.Status getStatus() {
        Util.Status status;
        Util.Status result = status = this.getInternalStatus();
        if (ConfigurationOptions.skippedFailsBuild() && (status == Util.Status.SKIPPED || status == Util.Status.FAILED)) {
            result = Util.Status.FAILED;
        }
        if (ConfigurationOptions.undefinedFailsBuild() && (status == Util.Status.UNDEFINED || status == Util.Status.FAILED)) {
            result = Util.Status.FAILED;
        }
        if (status == Util.Status.FAILED) {
            result = Util.Status.FAILED;
        }
        return result;
    }

    public Long getDuration() {
        if (this.result == null) {
            return 1L;
        }
        return this.result.getDuration();
    }

    public String getDataTableClass() {
        String content = "";
        Util.Status status = this.getStatus();
        content = status == Util.Status.FAILED ? "failed" : (status == Util.Status.PASSED ? "passed" : (status == Util.Status.SKIPPED ? "skipped" : ""));
        return content;
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        String content = "";
        if (this.getStatus() == Util.Status.FAILED) {
            String errorMessage = this.result.getErrorMessage();
            if (this.getInternalStatus() == Util.Status.SKIPPED) {
                errorMessage = "Mode: Skipped causes Failure<br/><span class=\"skipped\">This step was skipped</span>";
            }
            if (this.getInternalStatus() == Util.Status.UNDEFINED) {
                errorMessage = "Mode: Not Implemented causes Failure<br/><span class=\"undefined\">This step is not yet implemented</span>";
            }
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + "<div class=\"step-error-message\"><pre>" + this.formatError(errorMessage) + "</pre></div>" + Util.closeDiv() + this.getImageTag();
        } else if (this.getStatus() == Util.Status.MISSING) {
            String errorMessage = "<span class=\"missing\">Result was missing for this step</span>";
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + "<div class=\"step-error-message\"><pre>" + this.formatError(errorMessage) + "</pre></div>" + Util.closeDiv();
        } else {
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + Util.closeDiv() + this.getImageTag();
        }
        return content;
    }

    private String formatError(String errorMessage) {
        String result = errorMessage;
        if (errorMessage != null || !errorMessage.isEmpty()) {
            result = errorMessage.replaceAll("\\\\n", "<br/>");
        }
        return result;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getImageTag() {
        if (this.noEmbeddedScreenshots()) {
            return "";
        }
        String imageId = Long.toString(new DateTime().getMillis());
        return "<a href=\"\" onclick=\"img=document.getElementById('" + imageId + "'); img.style.display = (img.style.display == 'none' ? 'block' : 'none');return false\">Screenshot</a>" + "<img id='" + imageId + "' style='display:none' src='" + this.getMimeEncodedEmbeddedImage() + "'>";
    }

    private boolean noEmbeddedScreenshots() {
        return this.getEmbeddings() == null;
    }

    public String getMimeEncodedEmbeddedImage() {
        return "data:image/png;base64," + ((StringMap)this.getEmbeddings()[0]).get((Object)"data");
    }

    public static class predicates {
        public static LogicalPredicate<Step> hasStatus(final Util.Status status) {
            return new LogicalPredicate<Step>(){

                public boolean matches(Step step) {
                    return step.getStatus().equals((Object)status);
                }
            };
        }

        public static Function1<Step, Util.Status> status() {
            return new Function1<Step, Util.Status>(){

                public Util.Status call(Step step) throws Exception {
                    return step.getStatus();
                }
            };
        }
    }

    public static class functions {
        public static Function1<Step, Util.Status> status() {
            return new Function1<Step, Util.Status>(){

                public Util.Status call(Step step) throws Exception {
                    return step.getStatus();
                }
            };
        }
    }
}

