/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.masterthought.cucumber.ArtifactProcessor;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ReportInformation;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.TagObject;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.UnzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class ReportBuilder {
    ReportInformation ri;
    private File reportDirectory;
    private String buildNumber;
    private String buildProject;
    private String pluginUrlPath;
    private boolean flashCharts;
    private boolean runWithJenkins;
    private boolean artifactsEnabled;
    private boolean highCharts;
    private boolean parsingError;
    private final String VERSION = "cucumber-reporting-0.0.21";

    public ReportBuilder(List<String> jsonReports, File reportDirectory, String pluginUrlPath, String buildNumber, String buildProject, boolean skippedFails, boolean undefinedFails, boolean flashCharts, boolean runWithJenkins, boolean artifactsEnabled, String artifactConfig, boolean highCharts) throws Exception {
        try {
            this.reportDirectory = reportDirectory;
            this.buildNumber = buildNumber;
            this.buildProject = buildProject;
            this.pluginUrlPath = this.getPluginUrlPath(pluginUrlPath);
            this.flashCharts = flashCharts;
            this.runWithJenkins = runWithJenkins;
            this.artifactsEnabled = artifactsEnabled;
            this.highCharts = highCharts;
            ConfigurationOptions.setSkippedFailsBuild(skippedFails);
            ConfigurationOptions.setUndefinedFailsBuild(undefinedFails);
            ConfigurationOptions.setArtifactsEnabled(artifactsEnabled);
            if (artifactsEnabled) {
                ArtifactProcessor artifactProcessor = new ArtifactProcessor(artifactConfig);
                ConfigurationOptions.setArtifactConfiguration(artifactProcessor.process());
            }
            ReportParser reportParser = new ReportParser(jsonReports);
            this.ri = new ReportInformation(reportParser.getFeatures());
        }
        catch (Exception exception) {
            this.parsingError = true;
            this.generateErrorPage(exception);
        }
    }

    public boolean getBuildStatus() {
        return this.ri.getTotalNumberFailingSteps() <= 0;
    }

    public void generateReports() throws Exception {
        block5: {
            try {
                this.copyResource("themes", "blue.zip");
                if (this.flashCharts) {
                    this.copyResource("charts", "flash_charts.zip");
                } else {
                    this.copyResource("charts", "js.zip");
                }
                if (this.artifactsEnabled) {
                    this.copyResource("charts", "codemirror.zip");
                }
                this.generateFeatureOverview();
                this.generateFeatureReports();
                this.generateTagReports();
                this.generateTagOverview();
            }
            catch (Exception exception) {
                if (this.parsingError) break block5;
                this.generateErrorPage(exception);
            }
        }
    }

    public void generateFeatureReports() throws Exception {
        for (Map.Entry<String, List<Feature>> pairs : this.ri.getProjectFeatureMap().entrySet()) {
            List<Feature> featureList = pairs.getValue();
            for (Feature feature : featureList) {
                VelocityEngine ve = new VelocityEngine();
                ve.init(this.getProperties());
                Template featureResult = ve.getTemplate("templates/featureReport.vm");
                VelocityContext context = new VelocityContext();
                context.put("version", (Object)"cucumber-reporting-0.0.21");
                context.put("feature", (Object)feature);
                context.put("report_status_colour", (Object)this.ri.getReportStatusColour(feature));
                context.put("build_project", (Object)this.buildProject);
                context.put("build_number", (Object)this.buildNumber);
                context.put("scenarios", (Object)feature.getElements().toList());
                context.put("time_stamp", (Object)this.ri.timeStamp());
                context.put("jenkins_base", (Object)this.pluginUrlPath);
                context.put("fromJenkins", (Object)this.runWithJenkins);
                context.put("artifactsEnabled", (Object)ConfigurationOptions.artifactsEnabled());
                this.generateReport(feature.getFileName(), featureResult, context);
            }
        }
    }

    private void generateFeatureOverview() throws Exception {
        int numberTotalPassed = this.ri.getTotalNumberPassingSteps();
        int numberTotalFailed = this.ri.getTotalNumberFailingSteps();
        int numberTotalSkipped = this.ri.getTotalNumberSkippedSteps();
        int numberTotalPending = this.ri.getTotalNumberPendingSteps();
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template featureOverview = ve.getTemplate("templates/featureOverview.vm");
        VelocityContext context = new VelocityContext();
        context.put("version", (Object)"cucumber-reporting-0.0.21");
        context.put("build_project", (Object)this.buildProject);
        context.put("build_number", (Object)this.buildNumber);
        context.put("features", this.ri.getFeatures());
        context.put("total_features", (Object)this.ri.getTotalNumberOfFeatures());
        context.put("total_scenarios", (Object)this.ri.getTotalNumberOfScenarios());
        context.put("total_steps", (Object)this.ri.getTotalNumberOfSteps());
        context.put("total_passes", (Object)numberTotalPassed);
        context.put("total_fails", (Object)numberTotalFailed);
        context.put("total_skipped", (Object)numberTotalSkipped);
        context.put("total_pending", (Object)numberTotalPending);
        context.put("scenarios_passed", (Object)this.ri.getTotalScenariosPassed());
        context.put("scenarios_failed", (Object)this.ri.getTotalScenariosFailed());
        if (this.flashCharts) {
            context.put("step_data", (Object)FlashChartBuilder.donutChart(numberTotalPassed, numberTotalFailed, numberTotalSkipped, numberTotalPending));
            context.put("scenario_data", (Object)FlashChartBuilder.pieChart(this.ri.getTotalScenariosPassed(), this.ri.getTotalScenariosFailed()));
        } else {
            JsChartUtil pie = new JsChartUtil();
            List<String> stepColours = pie.orderStepsByValue(numberTotalPassed, numberTotalFailed, numberTotalSkipped, numberTotalPending);
            context.put("step_data", stepColours);
            List<String> scenarioColours = pie.orderScenariosByValue(this.ri.getTotalScenariosPassed(), this.ri.getTotalScenariosFailed());
            context.put("scenario_data", scenarioColours);
        }
        context.put("time_stamp", (Object)this.ri.timeStamp());
        context.put("total_duration", (Object)this.ri.getTotalDurationAsString());
        context.put("jenkins_base", (Object)this.pluginUrlPath);
        context.put("fromJenkins", (Object)this.runWithJenkins);
        context.put("flashCharts", (Object)this.flashCharts);
        context.put("highCharts", (Object)this.highCharts);
        this.generateReport("feature-overview.html", featureOverview, context);
    }

    public void generateTagReports() throws Exception {
        for (TagObject tagObject : this.ri.getTags()) {
            VelocityEngine ve = new VelocityEngine();
            ve.init(this.getProperties());
            Template featureResult = ve.getTemplate("templates/tagReport.vm");
            VelocityContext context = new VelocityContext();
            context.put("version", (Object)"cucumber-reporting-0.0.21");
            context.put("tag", (Object)tagObject);
            context.put("time_stamp", (Object)this.ri.timeStamp());
            context.put("jenkins_base", (Object)this.pluginUrlPath);
            context.put("build_project", (Object)this.buildProject);
            context.put("build_number", (Object)this.buildNumber);
            context.put("fromJenkins", (Object)this.runWithJenkins);
            context.put("report_status_colour", (Object)this.ri.getTagReportStatusColour(tagObject));
            this.generateReport(tagObject.getTagName().replace("@", "").trim() + ".html", featureResult, context);
        }
    }

    public void generateTagOverview() throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template featureOverview = ve.getTemplate("templates/tagOverview.vm");
        VelocityContext context = new VelocityContext();
        context.put("version", (Object)"cucumber-reporting-0.0.21");
        context.put("build_project", (Object)this.buildProject);
        context.put("build_number", (Object)this.buildNumber);
        context.put("tags", this.ri.getTags());
        context.put("total_tags", (Object)this.ri.getTotalTags());
        context.put("total_scenarios", (Object)this.ri.getTotalTagScenarios());
        context.put("total_passed_scenarios", (Object)this.ri.getTotalPassingTagScenarios());
        context.put("total_failed_scenarios", (Object)this.ri.getTotalFailingTagScenarios());
        context.put("total_steps", (Object)this.ri.getTotalTagSteps());
        context.put("total_passes", (Object)this.ri.getTotalTagPasses());
        context.put("total_fails", (Object)this.ri.getTotalTagFails());
        context.put("total_skipped", (Object)this.ri.getTotalTagSkipped());
        context.put("total_pending", (Object)this.ri.getTotalTagPending());
        if (this.flashCharts) {
            context.put("chart_data", (Object)FlashChartBuilder.StackedColumnChart(this.ri.tagMap));
        } else if (this.highCharts) {
            context.put("chart_categories", (Object)JsChartUtil.getTags(this.ri.tagMap));
            context.put("chart_data", (Object)JsChartUtil.generateTagChartDataForHighCharts(this.ri.tagMap));
        } else {
            context.put("chart_rows", (Object)JsChartUtil.generateTagChartData(this.ri.tagMap));
        }
        context.put("total_duration", (Object)this.ri.getTotalTagDuration());
        context.put("time_stamp", (Object)this.ri.timeStamp());
        context.put("jenkins_base", (Object)this.pluginUrlPath);
        context.put("fromJenkins", (Object)this.runWithJenkins);
        context.put("flashCharts", (Object)this.flashCharts);
        context.put("highCharts", (Object)this.highCharts);
        this.generateReport("tag-overview.html", featureOverview, context);
    }

    public void generateErrorPage(Exception exception) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.init(this.getProperties());
        Template errorPage = ve.getTemplate("templates/errorPage.vm");
        VelocityContext context = new VelocityContext();
        context.put("version", (Object)"cucumber-reporting-0.0.21");
        context.put("build_number", (Object)this.buildNumber);
        context.put("fromJenkins", (Object)this.runWithJenkins);
        context.put("jenkins_base", (Object)this.pluginUrlPath);
        context.put("build_project", (Object)this.buildProject);
        context.put("error_message", (Object)exception);
        context.put("time_stamp", (Object)new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date()));
        this.generateReport("feature-overview.html", errorPage, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resourceLocation, String resourceName) throws IOException, URISyntaxException {
        File tmpResourcesArchive = File.createTempFile("temp", resourceName + ".zip");
        InputStream resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream(resourceLocation + "/" + resourceName);
        if (resourceArchiveInputStream == null) {
            resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream("/" + resourceLocation + "/" + resourceName);
        }
        FileOutputStream resourceArchiveOutputStream = new FileOutputStream(tmpResourcesArchive);
        try {
            IOUtils.copy((InputStream)resourceArchiveInputStream, (OutputStream)resourceArchiveOutputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceArchiveInputStream);
            IOUtils.closeQuietly((OutputStream)resourceArchiveOutputStream);
        }
        UnzipUtils.unzipToFile(tmpResourcesArchive, this.reportDirectory);
        FileUtils.deleteQuietly((File)tmpResourcesArchive);
    }

    private String getPluginUrlPath(String path) {
        return path.isEmpty() ? "/" : path;
    }

    private void generateReport(String fileName, Template featureResult, VelocityContext context) throws Exception {
        FileWriter writer = new FileWriter(new File(this.reportDirectory, fileName));
        featureResult.merge((Context)context, (Writer)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("resource.loader", "class");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.setProperty("runtime.log", new File(this.reportDirectory, "velocity.log").getPath());
        return props;
    }
}

