/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.util.Util;

public class Step {
    private String name;
    private String keyword;
    private String line;
    private Result result;
    private Row[] rows;

    public Row[] getRows() {
        return this.rows;
    }

    public boolean hasRows() {
        boolean result = false;
        if (this.rows != null && this.rows.length > 0) {
            result = true;
        }
        return result;
    }

    private Util.Status getInternalStatus() {
        if (this.result == null) {
            System.out.println("[WARNING] Line " + this.line + " : " + "Step is missing Result: " + this.keyword + " : " + this.name);
            return Util.Status.MISSING;
        }
        return Util.resultMap.get(this.result.getStatus());
    }

    public Util.Status getStatus() {
        Util.Status status;
        Util.Status result = status = this.getInternalStatus();
        if (ConfigurationOptions.skippedFailsBuild() && (status == Util.Status.SKIPPED || status == Util.Status.FAILED)) {
            result = Util.Status.FAILED;
        }
        if (ConfigurationOptions.undefinedFailsBuild() && (status == Util.Status.UNDEFINED || status == Util.Status.FAILED)) {
            result = Util.Status.FAILED;
        }
        if (status == Util.Status.FAILED) {
            result = Util.Status.FAILED;
        }
        return result;
    }

    public Long getDuration() {
        if (this.result == null) {
            return 1L;
        }
        return this.result.getDuration();
    }

    public String getDataTableClass() {
        String content = "";
        Util.Status status = this.getStatus();
        content = status == Util.Status.FAILED ? "failed" : (status == Util.Status.PASSED ? "passed" : (status == Util.Status.SKIPPED ? "skipped" : ""));
        return content;
    }

    public String getName() {
        String content = "";
        if (this.getStatus() == Util.Status.FAILED) {
            String errorMessage = this.result.getErrorMessage();
            if (this.getInternalStatus() == Util.Status.SKIPPED) {
                errorMessage = "Mode: Skipped causes Failure<br/><span class=\"skipped\">This step was skipped</span>";
            }
            if (this.getInternalStatus() == Util.Status.UNDEFINED) {
                errorMessage = "Mode: Not Implemented causes Failure<br/><span class=\"undefined\">This step is not yet implemented</span>";
            }
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + "<div class=\"step-error-message\"><pre>" + this.formatError(errorMessage) + "</pre></div>" + Util.closeDiv();
        } else if (this.getStatus() == Util.Status.MISSING) {
            String errorMessage = "<span class=\"missing\">Result was missing for this step</span>";
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + "<div class=\"step-error-message\"><pre>" + this.formatError(errorMessage) + "</pre></div>" + Util.closeDiv();
        } else {
            content = Util.result(this.getStatus()) + "<span class=\"step-keyword\">" + this.keyword + " </span><span class=\"step-name\">" + this.name + "</span>" + Util.closeDiv();
        }
        return content;
    }

    private String formatError(String errorMessage) {
        String result = errorMessage;
        if (errorMessage != null || !errorMessage.isEmpty()) {
            result = errorMessage.replaceAll("\\\\n", "<br/>");
        }
        return result;
    }
}

