/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.Closure;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature {
    private String name;
    private String uri;
    private String description;
    private String keyword;
    private Element[] elements;
    private Tag[] tags;
    private StepResults stepResults;

    public Element[] getElements() {
        return this.elements;
    }

    public String getFileName() {
        ArrayList<String> matches = new ArrayList<String>();
        for (String line : Splitter.onPattern((String)"/|\\\\").split((CharSequence)this.uri)) {
            String modified = line.replaceAll("\\)|\\(", "");
            modified = StringUtils.deleteWhitespace((String)modified).trim();
            matches.add(modified);
        }
        List sublist = matches.subList(1, matches.size());
        matches = sublist.size() == 0 ? matches : sublist;
        String fileName = Joiner.on((String)"-").join(matches) + ".html";
        return fileName;
    }

    public boolean hasTags() {
        return Util.itemExists(this.tags);
    }

    public List<String> getTagList() {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Tag tag : this.tags) {
            tagList.add(tag.getName());
        }
        return tagList;
    }

    public String getTags() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.itemExists(this.tags)) {
            String tagList = StringUtils.join((Object[])this.getTagList().toArray(), (String)",");
            result = "<div class=\"feature-tags\">" + tagList + "</div>";
        }
        return result;
    }

    public Util.Status getStatus() {
        Closure<String, Element> scenarioStatus = new Closure<String, Element>(){

            @Override
            public Util.Status call(Element step) {
                return step.getStatus();
            }
        };
        List<Object> results = new ArrayList();
        if (Util.itemExists(this.elements)) {
            results = Util.collectScenarios(this.elements, scenarioStatus);
        }
        return results.contains((Object)Util.Status.FAILED) ? Util.Status.FAILED : Util.Status.PASSED;
    }

    public String getName() {
        return Util.itemExists(this.name) ? Util.result(this.getStatus()) + "<div class=\"feature-line\"><span class=\"feature-keyword\">Feature:</span> " + this.name + "</div>" + Util.closeDiv() : "";
    }

    public String getRawName() {
        return Util.itemExists(this.name) ? this.name : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        String result = "";
        if (Util.itemExists(this.description)) {
            String content = this.description.replaceFirst("As an", "<span class=\"feature-role\">As an</span>");
            content = content.replaceFirst("I want to", "<span class=\"feature-action\">I want to</span>");
            content = content.replaceFirst("So that", "<span class=\"feature-value\">So that</span>");
            content = content.replaceAll("\n", "<br/>");
            result = "<div class=\"feature-description\">" + content + "</div>";
        }
        return result;
    }

    public int getNumberOfScenarios() {
        int result = 0;
        if (Util.itemExists(this.elements)) {
            result = this.elements.length;
        }
        return result;
    }

    public int getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public int getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public int getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public int getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public int getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public int getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public String getDurationOfSteps() {
        return this.stepResults.getTotalDurationAsString();
    }

    public void processSteps() {
        ArrayList<Step> allSteps = new ArrayList<Step>();
        List<Step> passedSteps = new ArrayList<Step>();
        List<Step> failedSteps = new ArrayList<Step>();
        List<Step> skippedSteps = new ArrayList<Step>();
        List<Step> pendingSteps = new ArrayList<Step>();
        List<Step> missingSteps = new ArrayList<Step>();
        Long totalDuration = 0L;
        if (Util.itemExists(this.elements)) {
            for (Element element : this.elements) {
                Step[] steps;
                if (!Util.hasSteps(element)) continue;
                for (Step step : steps = element.getSteps()) {
                    allSteps.add(step);
                    Util.Status stepStatus = step.getStatus();
                    passedSteps = Util.setStepStatus(passedSteps, step, stepStatus, Util.Status.PASSED);
                    failedSteps = Util.setStepStatus(failedSteps, step, stepStatus, Util.Status.FAILED);
                    skippedSteps = Util.setStepStatus(skippedSteps, step, stepStatus, Util.Status.SKIPPED);
                    pendingSteps = Util.setStepStatus(pendingSteps, step, stepStatus, Util.Status.UNDEFINED);
                    missingSteps = Util.setStepStatus(missingSteps, step, stepStatus, Util.Status.MISSING);
                    totalDuration = totalDuration + step.getDuration();
                }
            }
        }
        this.stepResults = new StepResults(allSteps, passedSteps, failedSteps, skippedSteps, pendingSteps, missingSteps, totalDuration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StepResults {
        List<Step> allSteps;
        List<Step> passedSteps;
        List<Step> failedSteps;
        List<Step> skippedSteps;
        List<Step> pendingSteps;
        List<Step> missingSteps;
        Long totalDuration;

        public StepResults(List<Step> allSteps, List<Step> passedSteps, List<Step> failedSteps, List<Step> skippedSteps, List<Step> pendingSteps, List<Step> missingSteps, Long totalDuration) {
            this.allSteps = allSteps;
            this.passedSteps = passedSteps;
            this.failedSteps = failedSteps;
            this.skippedSteps = skippedSteps;
            this.pendingSteps = pendingSteps;
            this.missingSteps = missingSteps;
            this.totalDuration = totalDuration;
        }

        public int getNumberOfSteps() {
            return this.allSteps.size();
        }

        public int getNumberOfPasses() {
            return this.passedSteps.size();
        }

        public int getNumberOfFailures() {
            return this.failedSteps.size();
        }

        public int getNumberOfPending() {
            return this.pendingSteps.size();
        }

        public int getNumberOfSkipped() {
            return this.skippedSteps.size();
        }

        public int getNumberOfMissing() {
            return this.missingSteps.size();
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public String getTotalDurationAsString() {
            return Util.formatDuration(this.totalDuration);
        }
    }
}

