/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.Closure;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.StringClosure;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    private String name;
    private String description;
    private String keyword;
    private Step[] steps;
    private Tag[] tags;

    public Step[] getSteps() {
        return this.steps;
    }

    public Util.Status getStatus() {
        Closure<String, Step> scenarioStatus = new Closure<String, Step>(){

            @Override
            public Util.Status call(Step step) {
                return step.getStatus();
            }
        };
        List results = Util.collectSteps(this.steps, scenarioStatus);
        return results.contains((Object)Util.Status.FAILED) ? Util.Status.FAILED : Util.Status.PASSED;
    }

    public String getName() {
        ArrayList<String> contentString = new ArrayList<String>();
        if (Util.itemExists(this.keyword)) {
            contentString.add("<span class=\"scenario-keyword\">" + this.keyword + ": </span>");
        }
        if (Util.itemExists(this.name)) {
            contentString.add("<span class=\"scenario-name\">" + this.name + "</span>");
        }
        return Util.itemExists(contentString) ? Util.result(this.getStatus()) + StringUtils.join((Object[])contentString.toArray(), (String)" ") + Util.closeDiv() : "";
    }

    public List<String> getTagList() {
        return this.processTags();
    }

    public boolean hasTags() {
        return Util.itemExists(this.tags);
    }

    private List<String> processTags() {
        List<String> results = new ArrayList<String>();
        if (Util.itemExists(this.tags)) {
            StringClosure<String, Tag> scenarioTags = new StringClosure<String, Tag>(){

                @Override
                public String call(Tag tag) {
                    return tag.getName();
                }
            };
            results = Util.collectTags(this.tags, scenarioTags);
        }
        return results;
    }

    public String getTags() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.itemExists(this.tags)) {
            String tagList = StringUtils.join((Object[])this.processTags().toArray(), (String)",");
            result = "<div class=\"feature-tags\">" + tagList + "</div>";
        }
        return result;
    }
}

