/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.ScenarioTag;
import net.masterthought.cucumber.TagObject;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportInformation {
    private Map<String, List<Feature>> projectFeatureMap;
    private List<Feature> features;
    private int numberOfScenarios;
    private int numberOfSteps;
    private List<Step> totalPassingSteps = new ArrayList<Step>();
    private List<Step> totalFailingSteps = new ArrayList<Step>();
    private List<Step> totalSkippedSteps = new ArrayList<Step>();
    private List<Step> totalUndefinedSteps = new ArrayList<Step>();
    private List<Step> totalMissingSteps = new ArrayList<Step>();
    private List<Element> numberPassingScenarios = new ArrayList<Element>();
    private List<Element> numberFailingScenarios = new ArrayList<Element>();
    private Long totalDuration = 0L;
    List<TagObject> tagMap = new ArrayList<TagObject>();
    private int totalTagScenarios = 0;
    private int totalTagSteps = 0;
    private int totalTagPasses = 0;
    private int totalTagFails = 0;
    private int totalTagSkipped = 0;
    private int totalTagPending = 0;
    private long totalTagDuration = 0L;

    public ReportInformation(Map<String, List<Feature>> projectFeatureMap) {
        this.projectFeatureMap = projectFeatureMap;
        this.features = this.listAllFeatures();
        this.processFeatures();
    }

    private List<Feature> listAllFeatures() {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        for (Map.Entry<String, List<Feature>> pairs : this.projectFeatureMap.entrySet()) {
            List<Feature> featureList = pairs.getValue();
            allFeatures.addAll(featureList);
        }
        return allFeatures;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<TagObject> getTags() {
        return this.tagMap;
    }

    public Map<String, List<Feature>> getProjectFeatureMap() {
        return this.projectFeatureMap;
    }

    public int getTotalNumberOfScenarios() {
        return this.numberOfScenarios;
    }

    public int getTotalNumberOfFeatures() {
        return this.features.size();
    }

    public int getTotalNumberOfSteps() {
        return this.numberOfSteps;
    }

    public int getTotalNumberPassingSteps() {
        return this.totalPassingSteps.size();
    }

    public int getTotalNumberFailingSteps() {
        return this.totalFailingSteps.size();
    }

    public int getTotalNumberSkippedSteps() {
        return this.totalSkippedSteps.size();
    }

    public int getTotalNumberPendingSteps() {
        return this.totalUndefinedSteps.size();
    }

    public int getTotalNumberMissingSteps() {
        return this.totalMissingSteps.size();
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public String getReportStatusColour(Feature feature) {
        return feature.getStatus() == Util.Status.PASSED ? "#C5D88A" : "#D88A8A";
    }

    public String getTagReportStatusColour(TagObject tag) {
        return tag.getStatus() == Util.Status.PASSED ? "#C5D88A" : "#D88A8A";
    }

    public int getTotalTags() {
        return this.tagMap.size();
    }

    public int getTotalTagScenarios() {
        return this.totalTagScenarios;
    }

    public int getTotalTagSteps() {
        return this.totalTagSteps;
    }

    public int getTotalTagPasses() {
        return this.totalTagPasses;
    }

    public int getTotalTagFails() {
        return this.totalTagFails;
    }

    public int getTotalTagSkipped() {
        return this.totalTagSkipped;
    }

    public int getTotalTagPending() {
        return this.totalTagPending;
    }

    public String getTotalTagDuration() {
        return Util.formatDuration(this.totalTagDuration);
    }

    public int getTotalScenariosPassed() {
        return this.numberPassingScenarios.size();
    }

    public int getTotalScenariosFailed() {
        return this.numberFailingScenarios.size();
    }

    private void processTags() {
        for (TagObject tag : this.tagMap) {
            this.totalTagScenarios += tag.getScenarios().size();
            this.totalTagPasses += tag.getNumberOfPasses();
            this.totalTagFails += tag.getNumberOfFailures();
            this.totalTagSkipped += tag.getNumberOfSkipped();
            this.totalTagPending += tag.getNumberOfPending();
            for (ScenarioTag scenarioTag : tag.getScenarios()) {
                Step[] steps;
                if (!Util.hasSteps(scenarioTag)) continue;
                for (Step step : steps = scenarioTag.getScenario().getSteps()) {
                    this.totalTagSteps += steps.length;
                    this.totalTagDuration += step.getDuration().longValue();
                }
            }
        }
    }

    private void processFeatures() {
        for (Feature feature : this.features) {
            List<ScenarioTag> scenarioList = new ArrayList<ScenarioTag>();
            Element[] scenarios = feature.getElements();
            if (!Util.itemExists(scenarios)) continue;
            this.numberOfScenarios += scenarios.length;
            for (Element scenario : scenarios) {
                this.numberPassingScenarios = Util.setScenarioStatus(this.numberPassingScenarios, scenario, scenario.getStatus(), Util.Status.PASSED);
                this.numberFailingScenarios = Util.setScenarioStatus(this.numberFailingScenarios, scenario, scenario.getStatus(), Util.Status.FAILED);
                if (feature.hasTags()) {
                    scenarioList.add(new ScenarioTag(scenario, feature.getFileName()));
                    this.tagMap = this.createOrAppendToTagMap(this.tagMap, feature.getTagList(), scenarioList);
                }
                if (Util.hasScenarios(feature)) {
                    if (scenario.hasTags()) {
                        scenarioList = this.addScenarioUnlessExists(scenarioList, new ScenarioTag(scenario, feature.getFileName()));
                    }
                    this.tagMap = this.createOrAppendToTagMap(this.tagMap, scenario.getTagList(), scenarioList);
                }
                if (!Util.hasSteps(scenario)) continue;
                Step[] steps = scenario.getSteps();
                this.numberOfSteps += steps.length;
                for (Step step : steps) {
                    Util.Status stepStatus = step.getStatus();
                    this.totalPassingSteps = Util.setStepStatus(this.totalPassingSteps, step, stepStatus, Util.Status.PASSED);
                    this.totalFailingSteps = Util.setStepStatus(this.totalFailingSteps, step, stepStatus, Util.Status.FAILED);
                    this.totalSkippedSteps = Util.setStepStatus(this.totalSkippedSteps, step, stepStatus, Util.Status.SKIPPED);
                    this.totalUndefinedSteps = Util.setStepStatus(this.totalUndefinedSteps, step, stepStatus, Util.Status.UNDEFINED);
                    this.totalMissingSteps = Util.setStepStatus(this.totalMissingSteps, step, stepStatus, Util.Status.MISSING);
                    this.totalDuration = this.totalDuration + step.getDuration();
                }
            }
        }
        this.processTags();
    }

    private List<ScenarioTag> addScenarioUnlessExists(List<ScenarioTag> scenarioList, ScenarioTag scenarioTag) {
        boolean exists = false;
        for (ScenarioTag scenario : scenarioList) {
            if (!scenario.getParentFeatureUri().equalsIgnoreCase(scenarioTag.getParentFeatureUri()) || !scenario.getScenario().getName().equalsIgnoreCase(scenarioTag.getScenario().getName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            scenarioList.add(scenarioTag);
        }
        return scenarioList;
    }

    private List<TagObject> createOrAppendToTagMap(List<TagObject> tagMap, List<String> tagList, List<ScenarioTag> scenarioList) {
        for (String tag : tagList) {
            boolean exists = false;
            TagObject tagObj = null;
            for (TagObject tagObject : tagMap) {
                if (!tagObject.getTagName().equalsIgnoreCase(tag)) continue;
                exists = true;
                tagObj = tagObject;
                break;
            }
            if (exists) {
                List<ScenarioTag> existingTagList = tagObj.getScenarios();
                for (ScenarioTag scenarioTag : scenarioList) {
                    existingTagList = this.addScenarioUnlessExists(existingTagList, scenarioTag);
                }
                tagMap.remove(tagObj);
                tagObj.setScenarios(existingTagList);
                tagMap.add(tagObj);
                continue;
            }
            tagObj = new TagObject(tag, scenarioList);
            tagMap.add(tagObj);
        }
        return tagMap;
    }
}

