/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.text.indentation;

import net.markenwerk.utils.text.indentation.AbstractIndentation;
import net.markenwerk.utils.text.indentation.LineBreak;
import net.markenwerk.utils.text.indentation.Whitespace;

public final class WhitespaceIndentation
extends AbstractIndentation {
    public WhitespaceIndentation(Whitespace whitespace, int length) throws IllegalArgumentException {
        this(whitespace, length, LineBreak.SYSTEM);
    }

    public WhitespaceIndentation(Whitespace whitespace, int length, LineBreak lineBreak) throws IllegalArgumentException {
        super(WhitespaceIndentation.fromWhitespaceAndLength(whitespace, length), lineBreak);
    }

    private static String fromWhitespaceAndLength(Whitespace whitespace, int length) {
        if (null == whitespace) {
            throw new IllegalArgumentException("The given whitespace is null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The given length is negative");
        }
        String indentation = "";
        for (int i = 0; i < length; ++i) {
            indentation = indentation + whitespace.getWhitespaceString();
        }
        return indentation;
    }
}

