/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.text.indentation;

import java.io.IOException;
import net.markenwerk.utils.text.indentation.Indentation;
import net.markenwerk.utils.text.indentation.LineBreak;

public abstract class AbstractIndentation
implements Indentation {
    private final String indentationString;
    private final String lineBreakString;

    public AbstractIndentation(String indentationString, LineBreak lineBreak) {
        this(indentationString, AbstractIndentation.fromLineBreak(lineBreak));
    }

    private static String fromLineBreak(LineBreak lineBreak) {
        if (null == lineBreak) {
            throw new IllegalArgumentException("lineBreak is null");
        }
        return lineBreak.getLineBreakString();
    }

    public AbstractIndentation(String indentationString, String lineBreakString) throws IllegalArgumentException {
        if (null == indentationString) {
            throw new IllegalArgumentException("indentationString is null");
        }
        if (null == lineBreakString) {
            throw new IllegalArgumentException("lineBreakString is null");
        }
        this.indentationString = indentationString;
        this.lineBreakString = lineBreakString;
        lineBreakString = System.getProperty("line.separator");
    }

    @Override
    public String getLineBreak() {
        return this.lineBreakString;
    }

    @Override
    public final boolean isVisible() {
        return 0 != this.indentationString.length();
    }

    @Override
    public String get(int level) throws IllegalArgumentException {
        return this.get(level, false);
    }

    @Override
    public String get(int level, boolean includeLineBreak) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder();
        if (this.isVisible()) {
            if (includeLineBreak) {
                builder.append(this.lineBreakString);
            }
            for (int i = 0; i < level; ++i) {
                builder.append(this.indentationString);
            }
        }
        return builder.toString();
    }

    @Override
    public void appendTo(Appendable appendable, int level) throws IllegalArgumentException, IOException {
        this.appendTo(appendable, level, false);
    }

    @Override
    public void appendTo(Appendable appendable, int level, boolean includeLineBreak) throws IllegalArgumentException, IOException {
        if (null == appendable) {
            throw new IllegalArgumentException("appendable is null");
        }
        if (this.isVisible()) {
            if (includeLineBreak) {
                appendable.append(this.lineBreakString);
            }
            for (int i = 0; i < level; ++i) {
                appendable.append(this.indentationString);
            }
        }
    }
}

