/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import java.io.IOException;
import net.markenwerk.utils.json.parser.JsonSource;

public final class StringJsonSource
implements JsonSource {
    private String string;
    private int position;
    private int line = 1;
    private int column = 1;
    private int lastNewLinePosition;

    public StringJsonSource(String string) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("The given string is null");
        }
        this.string = string;
        if (0 != string.length() && '\ufeff' == string.charAt(0)) {
            ++this.position;
            ++this.column;
        }
    }

    @Override
    public int getAvailable() {
        return this.string.length() - this.position;
    }

    @Override
    public int makeAvailable() throws IOException {
        return this.string.length() - this.position;
    }

    @Override
    public boolean makeAvailable(int minimum) throws IOException {
        return this.position + minimum <= this.string.length();
    }

    @Override
    public char nextCharacter() {
        char result;
        if ('\n' == (result = this.string.charAt(this.position++))) {
            this.lastNewLinePosition = this.position;
            this.column = 1;
            ++this.line;
        }
        return result;
    }

    @Override
    public char peekCharacter(int offset) {
        return this.string.charAt(this.position + offset);
    }

    @Override
    public String nextString(int length) {
        String substring = this.string.substring(this.position, this.position + length);
        for (int i = 0; i < length; ++i) {
            this.nextCharacter();
        }
        return substring;
    }

    @Override
    public void appendNextString(StringBuilder builder, int length) {
        builder.append(this.string, this.position, this.position + length);
        for (int i = 0; i < length; ++i) {
            this.nextCharacter();
        }
    }

    @Override
    public String getPast(int maximum) {
        if (0 == this.position) {
            return "";
        }
        return this.string.substring(Math.max(0, this.position - maximum), this.position);
    }

    @Override
    public String getFuture(int maximum) {
        return this.string.substring(this.position, Math.min(this.position + maximum, this.string.length()));
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column + (this.position - this.lastNewLinePosition);
    }

    @Override
    public void close() throws IOException {
    }
}

