/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.markenwerk.utils.json.common.JsonSyntaxError;
import net.markenwerk.utils.json.common.JsonSyntaxException;
import net.markenwerk.utils.json.handler.JsonHandler;
import net.markenwerk.utils.json.handler.JsonHandlingException;
import net.markenwerk.utils.json.parser.CharacterArrayJsonSource;
import net.markenwerk.utils.json.parser.JsonParserMode;
import net.markenwerk.utils.json.parser.JsonPushParser;
import net.markenwerk.utils.json.parser.JsonSource;
import net.markenwerk.utils.json.parser.ReaderJsonSource;
import net.markenwerk.utils.json.parser.StringJsonSource;

public final class DefaultJsonPushParser
implements JsonPushParser {
    private final StringBuilder builder = new StringBuilder();
    private final JsonSource source;
    private final boolean multiDocumentMode;
    private final boolean strictStructMode;
    private JsonHandler<?> handler;

    public DefaultJsonPushParser(String string) throws IllegalArgumentException {
        this(new StringJsonSource(string));
    }

    public DefaultJsonPushParser(char[] characters) throws IllegalArgumentException {
        this(new CharacterArrayJsonSource(characters));
    }

    public DefaultJsonPushParser(Reader reader) throws IllegalArgumentException {
        this(new ReaderJsonSource(reader));
    }

    public DefaultJsonPushParser(JsonSource source) throws IllegalArgumentException {
        this(source, null);
    }

    public DefaultJsonPushParser(JsonSource source, JsonParserMode ... modes) throws IllegalArgumentException {
        if (null == source) {
            throw new IllegalArgumentException("source is null");
        }
        this.source = source;
        if (null != modes) {
            List<JsonParserMode> modesList = Arrays.asList(modes);
            this.multiDocumentMode = modesList.contains((Object)JsonParserMode.MULTI_DOCUMENT_MODE);
            this.strictStructMode = modesList.contains((Object)JsonParserMode.STRICT_STRUCT_MODE);
        } else {
            this.multiDocumentMode = false;
            this.strictStructMode = false;
        }
    }

    @Override
    public <Result> Result handle(JsonHandler<Result> handler) throws IllegalArgumentException, JsonHandlingException, JsonSyntaxException, IOException {
        if (null == handler) {
            throw new IllegalArgumentException("handler is null");
        }
        try {
            this.handler = handler;
            this.handleDocument();
            Object object = handler.getResult();
            return (Result)object;
        }
        finally {
            this.close();
        }
    }

    private void handleDocument() throws JsonSyntaxException, JsonHandlingException, IOException {
        block8: {
            do {
                this.handler.onDocumentBegin();
                char firstCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_DOCUMENT_START);
                if ('{' == firstCharacter) {
                    this.handleObjectFirst();
                } else if ('[' == firstCharacter) {
                    this.handleArrayFirst();
                } else {
                    if (this.strictStructMode) {
                        throw this.syntaxError(JsonSyntaxError.INVALID_DOCUMENT_START);
                    }
                    if ('\"' == firstCharacter) {
                        this.handler.onString(this.readNextString());
                    } else {
                        this.handleLiteral(firstCharacter);
                    }
                }
                this.handler.onDocumentEnd();
                if (!this.hasNextNonWhitespace()) break block8;
            } while (this.multiDocumentMode);
            throw this.syntaxError(JsonSyntaxError.INVALID_DOCUMENT_END);
        }
    }

    private void handleArrayFirst() throws JsonSyntaxException, JsonHandlingException, IOException {
        this.handler.onArrayBegin();
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_ARRAY_FIRST);
        if (']' == nextCharacter) {
            this.handler.onArrayEnd();
        } else {
            this.handleValue(nextCharacter, JsonSyntaxError.INVALID_ARRAY_FIRST);
            this.handleArrayFollowing();
        }
    }

    private void handleArrayFollowing() throws JsonSyntaxException, JsonHandlingException, IOException {
        block1: {
            while (true) {
                char nextCharacter;
                if (']' == (nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_ARRAY_FOLLOW))) break block1;
                if (',' != nextCharacter) break;
                this.handler.onNext();
                this.handleValue(JsonSyntaxError.INVALID_ARRAY_VALUE);
            }
            throw this.syntaxError(JsonSyntaxError.INVALID_ARRAY_FOLLOW);
        }
        this.handler.onArrayEnd();
    }

    private void handleObjectFirst() throws JsonSyntaxException, JsonHandlingException, IOException {
        this.handler.onObjectBegin();
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_FIRST);
        if ('}' == nextCharacter) {
            this.handler.onObjectEnd();
        } else if ('\"' == nextCharacter) {
            this.handleObjectValue();
            this.handleObjectFollowing();
        } else {
            throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_FIRST);
        }
    }

    private void handleObjectFollowing() throws JsonSyntaxException, JsonHandlingException, IOException {
        block1: {
            block2: {
                while (true) {
                    char nextCharacter;
                    if ('}' == (nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_FOLLOW))) break block1;
                    if (',' != nextCharacter) break block2;
                    nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_NAME);
                    if ('\"' != nextCharacter) break;
                    this.handler.onNext();
                    this.handleObjectValue();
                }
                throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_NAME);
            }
            throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_FOLLOW);
        }
        this.handler.onObjectEnd();
    }

    private void handleObjectValue() throws JsonSyntaxException, JsonHandlingException, IOException {
        this.handler.onName(this.readNextString());
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_SEPARATION);
        if (':' != nextCharacter) {
            throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_SEPARATION);
        }
        this.handleValue(JsonSyntaxError.INVALID_OBJECT_VALUE);
    }

    private void handleValue(JsonSyntaxError error) throws JsonSyntaxException, JsonHandlingException, IOException {
        this.handleValue(this.nextNonWhitespace(error), error);
    }

    private void handleValue(char firstCharacter, JsonSyntaxError error) throws JsonSyntaxException, JsonHandlingException, IOException {
        if ('{' == firstCharacter) {
            this.handleObjectFirst();
        } else if ('[' == firstCharacter) {
            this.handleArrayFirst();
        } else if ('\"' == firstCharacter) {
            this.handler.onString(this.readNextString());
        } else {
            if (']' == firstCharacter) {
                throw this.syntaxError(error);
            }
            if ('}' == firstCharacter) {
                throw this.syntaxError(error);
            }
            this.handleLiteral(firstCharacter);
        }
    }

    private char nextNonWhitespace(JsonSyntaxError error) throws JsonSyntaxException, IOException {
        while (this.source.makeAvailable(1)) {
            int n = this.source.getAvailable();
            for (int i = 0; i < n; ++i) {
                char nextCharacter = this.source.nextCharacter();
                if (' ' == nextCharacter || '\t' == nextCharacter || '\n' == nextCharacter || '\r' == nextCharacter) continue;
                return nextCharacter;
            }
        }
        throw this.syntaxError(error);
    }

    private boolean hasNextNonWhitespace() throws JsonSyntaxException, IOException {
        while (0 != this.source.makeAvailable()) {
            int n = this.source.getAvailable();
            for (int i = 0; i < n; ++i) {
                char nextCharacter = this.source.peekCharacter(0);
                if (' ' != nextCharacter && '\t' != nextCharacter && '\n' != nextCharacter && '\r' != nextCharacter) {
                    return true;
                }
                this.source.nextCharacter();
            }
        }
        return false;
    }

    private String readNextString() throws JsonSyntaxException, IOException {
        this.builder.setLength(0);
        boolean buffered = false;
        while (this.source.makeAvailable(1)) {
            int offset;
            int available = this.source.getAvailable();
            for (offset = 0; offset < available; ++offset) {
                char nextCharacter = this.source.peekCharacter(offset);
                if ('\"' == nextCharacter) {
                    String stringValue;
                    if (buffered) {
                        this.source.appendNextString(this.builder, offset);
                        stringValue = this.builder.toString();
                    } else {
                        stringValue = this.source.nextString(offset);
                    }
                    this.source.nextCharacter();
                    return stringValue;
                }
                if ('\\' != nextCharacter) continue;
                buffered = true;
                this.source.appendNextString(this.builder, offset);
                this.source.nextCharacter();
                this.builder.append(this.readEscaped());
                offset = -1;
                break;
            }
            if (-1 == offset) continue;
            buffered = true;
            this.source.appendNextString(this.builder, offset);
        }
        throw this.syntaxError(JsonSyntaxError.UNTERMINATED_STRING);
    }

    private char readEscaped() throws JsonSyntaxException, IOException {
        if (!this.source.makeAvailable(1)) {
            throw this.syntaxError(JsonSyntaxError.UNFINISHED_ESCAPE_SEQUENCE);
        }
        switch (this.source.nextCharacter()) {
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                return this.readUnicodeEscaped();
            }
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_ESCAPE_SEQUENCE);
    }

    private char readUnicodeEscaped() throws JsonSyntaxException, IOException {
        if (!this.source.makeAvailable(4)) {
            throw this.syntaxError(JsonSyntaxError.UNFINISHED_UNICODE_ESCAPE_SEQUENCE);
        }
        String hex = this.source.nextString(4);
        try {
            return (char)Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            if (hex.contains("\"")) {
                throw this.syntaxError(JsonSyntaxError.UNFINISHED_UNICODE_ESCAPE_SEQUENCE);
            }
            throw this.syntaxError(JsonSyntaxError.INVALID_UNICODE_ESCAPE_SEQUENCE);
        }
    }

    private void handleLiteral(char firstCharacter) throws JsonSyntaxException, JsonHandlingException, IOException {
        this.builder.setLength(0);
        this.builder.append(firstCharacter);
        while (0 != this.source.makeAvailable()) {
            switch (this.source.peekCharacter(0)) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    this.handleLiteral(this.builder.toString());
                    return;
                }
            }
            this.builder.append(this.source.nextCharacter());
        }
        this.handleLiteral(this.builder.toString());
    }

    private void handleLiteral(String literal) throws JsonSyntaxException, JsonHandlingException {
        if ("null".equals(literal)) {
            this.handler.onNull();
        } else if ("false".equals(literal)) {
            this.handler.onBoolean(false);
        } else if ("true".equals(literal)) {
            this.handler.onBoolean(true);
        } else {
            this.handleNumber(literal);
        }
    }

    private void handleNumber(String literal) throws JsonSyntaxException, JsonHandlingException {
        try {
            this.handler.onLong(Long.parseLong(literal));
        }
        catch (NumberFormatException ignored) {
            try {
                this.handler.onDouble(Double.parseDouble(literal));
            }
            catch (NumberFormatException e) {
                throw this.syntaxError(JsonSyntaxError.INVALID_LITERAL);
            }
        }
    }

    private JsonSyntaxException syntaxError(JsonSyntaxError error) {
        return new JsonSyntaxException(error, this.source.getLine(), this.source.getColumn() - 1, this.source.getPast(5), this.source.getFuture(5));
    }

    @Override
    public int getLine() {
        return this.source.getLine();
    }

    @Override
    public int getColumn() {
        return this.source.getColumn();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public String toString() {
        return "JsonReader [line=" + this.source.getLine() + ", column=" + this.source.getColumn() + ", near='" + this.source.getPast(15) + this.source.getFuture(15) + "']";
    }
}

