/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import net.markenwerk.utils.json.parser.JsonSyntaxError;

public final class JsonSyntaxException
extends Exception {
    private static final long serialVersionUID = 4648280170907086815L;
    private final JsonSyntaxError error;
    private final int line;
    private final int column;
    private final String past;
    private final String future;

    public JsonSyntaxException(JsonSyntaxError error, int line, int column, String past, String future) {
        this.error = error;
        this.line = line;
        this.column = column;
        this.past = past;
        this.future = future;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.error.getDescription());
        builder.append(" (");
        builder.append(this.error.getExpectation());
        builder.append(") at line ");
        builder.append(this.line);
        builder.append(", column ");
        builder.append(this.column);
        builder.append(", after '");
        builder.append(this.past);
        builder.append("', before '");
        builder.append(this.future);
        builder.append("'");
        return builder.toString();
    }

    public JsonSyntaxError getError() {
        return this.error;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getPast() {
        return this.past;
    }

    public String getFuture() {
        return this.future;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

