/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.markenwerk.utils.json.parser.CharacterArrayJsonSource;
import net.markenwerk.utils.json.parser.Context;
import net.markenwerk.utils.json.parser.JsonParserMode;
import net.markenwerk.utils.json.parser.JsonPullParser;
import net.markenwerk.utils.json.parser.JsonSource;
import net.markenwerk.utils.json.parser.JsonState;
import net.markenwerk.utils.json.parser.JsonSyntaxError;
import net.markenwerk.utils.json.parser.JsonSyntaxException;
import net.markenwerk.utils.json.parser.ReaderJsonSource;
import net.markenwerk.utils.json.parser.Stack;
import net.markenwerk.utils.json.parser.StringJsonSource;

public final class JsonSourcePullParser
implements JsonPullParser {
    private final StringBuilder builder = new StringBuilder();
    private final Stack<Context> stack = new Stack();
    private final JsonSource source;
    private JsonState state;
    private boolean booleanValue;
    private long longValue;
    private double doubleValue;
    private boolean multiDocumentMode;
    private boolean strictStructMode;

    public JsonSourcePullParser(String string) throws IllegalArgumentException {
        this(new StringJsonSource(string), null);
    }

    public JsonSourcePullParser(char[] characters) throws IllegalArgumentException {
        this(new CharacterArrayJsonSource(characters), null);
    }

    public JsonSourcePullParser(Reader reader) throws IllegalArgumentException {
        this(new ReaderJsonSource(reader), null);
    }

    public JsonSourcePullParser(Reader reader, int size) throws IllegalArgumentException {
        this(new ReaderJsonSource(reader, size), null);
    }

    public JsonSourcePullParser(JsonSource source) throws IllegalArgumentException {
        this(source, null);
    }

    public JsonSourcePullParser(JsonSource source, JsonParserMode ... modes) throws IllegalArgumentException {
        if (null == source) {
            throw new IllegalArgumentException("source is null");
        }
        this.source = source;
        if (null != modes) {
            List<JsonParserMode> modesList = Arrays.asList(modes);
            this.multiDocumentMode = modesList.contains((Object)JsonParserMode.MULTI_DOCUMENT_MODE);
            this.strictStructMode = modesList.contains((Object)JsonParserMode.STRICT_STRUCT_MODE);
        } else {
            this.multiDocumentMode = false;
            this.strictStructMode = false;
        }
        this.stack.push(Context.BEFORE_PARSE);
    }

    private JsonState nextState() throws JsonSyntaxException, IOException {
        switch ((Context)((Object)this.stack.peek())) {
            case BEFORE_PARSE: {
                this.stack.push(Context.EMPTY_DOCUMENT);
                return JsonState.DOCUMENT_BEGIN;
            }
            case AFTER_PARSE: {
                return JsonState.SOURCE_END;
            }
            case EMPTY_DOCUMENT: {
                return this.prepareDocument();
            }
            case EMPTY_ARRAY: {
                return this.prepareArrayFirst();
            }
            case NONEMPTY_ARRAY: {
                return this.prepareArrayFollowing();
            }
            case EMPTY_OBJECT: {
                return this.prepareObjectFirst();
            }
            case NONEMPTY_OBJECT: {
                return this.prepareObjectFollowing();
            }
            case DANGLING_NAME: {
                return this.prepareObjectValue();
            }
            case NONEMPTY_DOCUMENT: {
                this.stack.pop();
                if (this.hasNextNonWhitespace()) {
                    if (this.multiDocumentMode) {
                        this.stack.replace(Context.BEFORE_PARSE);
                        return JsonState.DOCUMENT_END;
                    }
                    throw this.syntaxError(JsonSyntaxError.INVALID_DOCUMENT_END);
                }
                this.stack.replace(Context.AFTER_PARSE);
                return JsonState.DOCUMENT_END;
            }
            case CLOSED: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private void consume(JsonState expected) throws JsonSyntaxException, IllegalStateException, IOException {
        this.currentState();
        if (this.state != expected) {
            throw new IllegalStateException("Current state is " + (Object)((Object)this.state) + " (expected " + (Object)((Object)expected) + ")");
        }
        this.state = null;
    }

    private JsonState prepareDocument() throws JsonSyntaxException, IOException {
        this.stack.replace(Context.NONEMPTY_DOCUMENT);
        char firstCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_DOCUMENT_START);
        if ('[' == firstCharacter) {
            this.stack.push(Context.EMPTY_ARRAY);
            return JsonState.ARRAY_BEGIN;
        }
        if ('{' == firstCharacter) {
            this.stack.push(Context.EMPTY_OBJECT);
            return JsonState.OBJECT_BEGIN;
        }
        if (this.strictStructMode) {
            throw this.syntaxError(JsonSyntaxError.INVALID_DOCUMENT_START);
        }
        if ('\"' == firstCharacter) {
            return JsonState.STRING;
        }
        return this.prepareNextLiteral(firstCharacter);
    }

    private JsonState prepareArrayFirst() throws JsonSyntaxException, IOException {
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_ARRAY_FIRST);
        if (']' == nextCharacter) {
            this.stack.pop();
            return JsonState.ARRAY_END;
        }
        this.stack.replace(Context.NONEMPTY_ARRAY);
        return this.prepareNextValue(nextCharacter, JsonSyntaxError.INVALID_ARRAY_FIRST);
    }

    private JsonState prepareArrayFollowing() throws JsonSyntaxException, IOException {
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_ARRAY_FOLLOW);
        if (',' == nextCharacter) {
            return this.prepareNextValue(JsonSyntaxError.INVALID_ARRAY_VALUE);
        }
        if (']' == nextCharacter) {
            this.stack.pop();
            return JsonState.ARRAY_END;
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_ARRAY_FOLLOW);
    }

    private JsonState prepareObjectFirst() throws JsonSyntaxException, IOException {
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_FIRST);
        if ('\"' == nextCharacter) {
            this.stack.replace(Context.DANGLING_NAME);
            return JsonState.NAME;
        }
        if ('}' == nextCharacter) {
            this.stack.pop();
            return JsonState.OBJECT_END;
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_FIRST);
    }

    private JsonState prepareObjectFollowing() throws JsonSyntaxException, IOException {
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_FOLLOW);
        if (',' == nextCharacter) {
            nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_NAME);
            if ('\"' == nextCharacter) {
                this.stack.replace(Context.DANGLING_NAME);
                return JsonState.NAME;
            }
            throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_NAME);
        }
        if ('}' == nextCharacter) {
            this.stack.pop();
            return JsonState.OBJECT_END;
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_FOLLOW);
    }

    private JsonState prepareObjectValue() throws JsonSyntaxException, IOException {
        char nextCharacter = this.nextNonWhitespace(JsonSyntaxError.INVALID_OBJECT_SEPARATION);
        if (':' == nextCharacter) {
            this.stack.replace(Context.NONEMPTY_OBJECT);
            return this.prepareNextValue(JsonSyntaxError.INVALID_OBJECT_VALUE);
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_OBJECT_SEPARATION);
    }

    private JsonState prepareNextValue(JsonSyntaxError error) throws JsonSyntaxException, IOException {
        return this.prepareNextValue(this.nextNonWhitespace(error), error);
    }

    private JsonState prepareNextValue(char firstCharacter, JsonSyntaxError error) throws JsonSyntaxException, IOException {
        if ('[' == firstCharacter) {
            this.stack.push(Context.EMPTY_ARRAY);
            return JsonState.ARRAY_BEGIN;
        }
        if ('{' == firstCharacter) {
            this.stack.push(Context.EMPTY_OBJECT);
            return JsonState.OBJECT_BEGIN;
        }
        if ('\"' == firstCharacter) {
            return JsonState.STRING;
        }
        if (']' == firstCharacter) {
            throw this.syntaxError(error);
        }
        if ('}' == firstCharacter) {
            throw this.syntaxError(error);
        }
        return this.prepareNextLiteral(firstCharacter);
    }

    private char nextNonWhitespace(JsonSyntaxError error) throws JsonSyntaxException, IOException {
        while (this.source.makeAvailable(1)) {
            int n = this.source.getAvailable();
            for (int i = 0; i < n; ++i) {
                char nextCharacter = this.source.nextCharacter();
                if (' ' == nextCharacter || '\t' == nextCharacter || '\n' == nextCharacter || '\r' == nextCharacter) continue;
                return nextCharacter;
            }
        }
        throw this.syntaxError(error);
    }

    private boolean hasNextNonWhitespace() throws JsonSyntaxException, IOException {
        while (0 != this.source.makeAvailable()) {
            int n = this.source.getAvailable();
            for (int i = 0; i < n; ++i) {
                char nextCharacter = this.source.peekCharacter(0);
                if (' ' != nextCharacter && '\t' != nextCharacter && '\n' != nextCharacter && '\r' != nextCharacter) {
                    return true;
                }
                this.source.nextCharacter();
            }
        }
        return false;
    }

    private String getNextString() throws JsonSyntaxException, IOException {
        this.builder.setLength(0);
        boolean buffered = false;
        while (this.source.makeAvailable(1)) {
            int offset;
            int available = this.source.getAvailable();
            for (offset = 0; offset < available; ++offset) {
                char nextCharacter = this.source.peekCharacter(offset);
                if ('\"' == nextCharacter) {
                    String stringValue;
                    if (buffered) {
                        this.source.appendNextString(this.builder, offset);
                        stringValue = this.builder.toString();
                    } else {
                        stringValue = this.source.nextString(offset);
                    }
                    this.source.nextCharacter();
                    return stringValue;
                }
                if ('\\' != nextCharacter) continue;
                buffered = true;
                this.source.appendNextString(this.builder, offset);
                this.source.nextCharacter();
                this.builder.append(this.readEscaped());
                offset = -1;
                break;
            }
            if (-1 == offset) continue;
            buffered = true;
            this.source.appendNextString(this.builder, offset);
        }
        throw this.syntaxError(JsonSyntaxError.UNTERMINATED_STRING);
    }

    private Reader readNextString() throws JsonSyntaxException, IOException {
        return new Reader(){
            private boolean endReached = false;

            @Override
            public int read(char[] buffer, int offset, int maxLength) throws IOException {
                int readValue;
                int amount;
                if (this.endReached) {
                    return -1;
                }
                for (amount = 0; amount < maxLength && -1 != (readValue = this.read()); ++amount) {
                    buffer[offset + amount] = (char)readValue;
                }
                return amount;
            }

            @Override
            public int read() throws IOException {
                if (!JsonSourcePullParser.this.source.makeAvailable(1)) {
                    JsonSyntaxException e = JsonSourcePullParser.this.syntaxError(JsonSyntaxError.UNTERMINATED_STRING);
                    throw new IOException(e.getMessage(), e);
                }
                char character = JsonSourcePullParser.this.source.nextCharacter();
                if ('\"' == character) {
                    this.endReached = true;
                    return -1;
                }
                if ('\\' == character) {
                    try {
                        return JsonSourcePullParser.this.readEscaped();
                    }
                    catch (JsonSyntaxException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                return character;
            }

            @Override
            public void close() throws IOException {
                while (!this.endReached) {
                    this.read();
                }
            }
        };
    }

    private void skipNextString() throws JsonSyntaxException, IOException {
        while (this.source.makeAvailable(1)) {
            int available = this.source.getAvailable();
            for (int i = 0; i < available; ++i) {
                char nextCharacter = this.source.nextCharacter();
                if ('\"' != nextCharacter) continue;
                return;
            }
        }
        throw this.syntaxError(JsonSyntaxError.UNTERMINATED_STRING);
    }

    private char readEscaped() throws JsonSyntaxException, IOException {
        if (!this.source.makeAvailable(1)) {
            throw this.syntaxError(JsonSyntaxError.UNFINISHED_ESCAPE_SEQUENCE);
        }
        switch (this.source.nextCharacter()) {
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                return this.readUnicodeEscaped();
            }
        }
        throw this.syntaxError(JsonSyntaxError.INVALID_ESCAPE_SEQUENCE);
    }

    private char readUnicodeEscaped() throws JsonSyntaxException, IOException {
        if (!this.source.makeAvailable(4)) {
            throw this.syntaxError(JsonSyntaxError.UNFINISHED_UNICODE_ESCAPE_SEQUENCE);
        }
        String hex = this.source.nextString(4);
        try {
            return (char)Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            if (hex.contains("\"")) {
                throw this.syntaxError(JsonSyntaxError.UNFINISHED_UNICODE_ESCAPE_SEQUENCE);
            }
            throw this.syntaxError(JsonSyntaxError.INVALID_UNICODE_ESCAPE_SEQUENCE);
        }
    }

    private JsonState prepareNextLiteral(char firstCharacter) throws JsonSyntaxException, IOException {
        this.builder.setLength(0);
        this.builder.append(firstCharacter);
        while (0 != this.source.makeAvailable()) {
            switch (this.source.peekCharacter(0)) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    return this.decodeLiteral(this.builder.toString());
                }
            }
            this.builder.append(this.source.nextCharacter());
        }
        return this.decodeLiteral(this.builder.toString());
    }

    private JsonState decodeLiteral(String literal) throws JsonSyntaxException {
        if ("null".equals(literal)) {
            return JsonState.NULL;
        }
        if ("false".equals(literal)) {
            this.booleanValue = false;
            return JsonState.BOOLEAN;
        }
        if ("true".equals(literal)) {
            this.booleanValue = true;
            return JsonState.BOOLEAN;
        }
        return this.decodeNumber(literal);
    }

    private JsonState decodeNumber(String literal) throws JsonSyntaxException {
        try {
            this.longValue = Long.parseLong(literal);
            return JsonState.LONG;
        }
        catch (NumberFormatException ignored) {
            try {
                this.doubleValue = Double.parseDouble(literal);
                return JsonState.DOUBLE;
            }
            catch (NumberFormatException e) {
                throw this.syntaxError(JsonSyntaxError.INVALID_LITERAL);
            }
        }
    }

    private JsonSyntaxException syntaxError(JsonSyntaxError error) {
        return new JsonSyntaxException(error, this.source.getLine(), this.source.getColumn() - 1, this.source.getPast(15), this.source.getFuture(15));
    }

    @Override
    public boolean hasNext() throws JsonSyntaxException, IOException {
        this.currentState();
        return JsonState.OBJECT_END != this.state && JsonState.ARRAY_END != this.state;
    }

    @Override
    public JsonState currentState() throws JsonSyntaxException, IOException {
        if (null == this.state) {
            this.state = this.nextState();
        }
        return this.state;
    }

    @Override
    public void beginDocument() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.DOCUMENT_BEGIN);
    }

    @Override
    public void endDocument() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.DOCUMENT_END);
    }

    @Override
    public void beginArray() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.ARRAY_BEGIN);
    }

    @Override
    public void endArray() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.ARRAY_END);
    }

    @Override
    public void beginObject() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.OBJECT_BEGIN);
    }

    @Override
    public void endObject() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.OBJECT_END);
    }

    @Override
    public void nextNull() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.NULL);
    }

    @Override
    public boolean nextBoolean() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.BOOLEAN);
        return this.booleanValue;
    }

    @Override
    public byte nextByte() throws ArithmeticException, IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.LONG);
        if (this.longValue < -128L) {
            throw new ArithmeticException("Value is too small to be a byte");
        }
        if (this.longValue > 127L) {
            throw new ArithmeticException("Value is too large to be a byte");
        }
        return (byte)this.longValue;
    }

    @Override
    public char nextCharacter() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.LONG);
        if (this.longValue < 0L) {
            throw new ArithmeticException("Value is too small to be a character");
        }
        if (this.longValue > 65535L) {
            throw new ArithmeticException("Value is too large to be a character");
        }
        return (char)this.longValue;
    }

    @Override
    public short nextShort() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.LONG);
        if (this.longValue < -32768L) {
            throw new ArithmeticException("Value is too small to be a short");
        }
        if (this.longValue > 32767L) {
            throw new ArithmeticException("Value is too large to be a short");
        }
        return (short)this.longValue;
    }

    @Override
    public int nextInteger() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.LONG);
        if (this.longValue < Integer.MIN_VALUE) {
            throw new ArithmeticException("Value is too small to be an integer");
        }
        if (this.longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Value is too large to be an integer");
        }
        return (int)this.longValue;
    }

    @Override
    public long nextLong() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.LONG);
        return this.longValue;
    }

    @Override
    public float nextFloat() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.DOUBLE);
        return (float)this.doubleValue;
    }

    @Override
    public double nextDouble() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.DOUBLE);
        return this.doubleValue;
    }

    @Override
    public String nextString() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.STRING);
        return this.getNextString();
    }

    @Override
    public Reader readString() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.STRING);
        return this.readNextString();
    }

    @Override
    public String nextName() throws IllegalStateException, JsonSyntaxException, IOException {
        this.consume(JsonState.NAME);
        return this.getNextString();
    }

    @Override
    public void skipValue() throws JsonSyntaxException, IOException {
        switch (this.currentState()) {
            case ARRAY_END: 
            case OBJECT_END: 
            case DOCUMENT_END: {
                return;
            }
            case NAME: {
                this.nextName();
            }
        }
        int depth = 0;
        do {
            switch (this.currentState()) {
                case ARRAY_BEGIN: 
                case OBJECT_BEGIN: {
                    ++depth;
                    break;
                }
                case ARRAY_END: 
                case OBJECT_END: {
                    --depth;
                    break;
                }
                case NAME: 
                case STRING: {
                    this.skipNextString();
                    break;
                }
            }
            this.state = null;
        } while (0 != depth);
        this.currentState();
    }

    @Override
    public void close() throws IOException {
        this.stack.clear();
        this.stack.push(Context.CLOSED);
        this.source.close();
    }

    @Override
    public int getLine() {
        return this.source.getLine();
    }

    @Override
    public int getColumn() {
        return this.source.getColumn();
    }

    public String toString() {
        return "JsonReader [line=" + this.source.getLine() + ", column=" + this.source.getColumn() + ", near='" + this.source.getPast(15) + this.source.getFuture(15) + "']";
    }
}

