/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import java.io.IOException;
import net.markenwerk.utils.json.parser.JsonSource;

public final class CharacterArrayJsonSource
implements JsonSource {
    private char[] characters;
    private int position;
    private int line = 1;
    private int column = 1;
    private int lastNewLinePosition;

    public CharacterArrayJsonSource(char[] characters) throws IllegalArgumentException {
        if (null == characters) {
            throw new IllegalArgumentException("characters is null");
        }
        this.characters = characters;
        if (0 != characters.length && '\ufeff' == characters[0]) {
            ++this.position;
            ++this.column;
        }
    }

    @Override
    public int getAvailable() {
        return this.characters.length - this.position;
    }

    @Override
    public int makeAvailable() throws IOException {
        return this.characters.length - this.position;
    }

    @Override
    public boolean makeAvailable(int minimum) throws IOException {
        return this.position + minimum <= this.characters.length;
    }

    @Override
    public char nextCharacter() {
        char result;
        if ('\n' == (result = this.characters[this.position++])) {
            this.lastNewLinePosition = this.position;
            this.column = 1;
            ++this.line;
        }
        return result;
    }

    @Override
    public char peekCharacter(int offset) {
        return this.characters[this.position + offset];
    }

    @Override
    public String nextString(int length) {
        String string = new String(this.characters, this.position, length);
        for (int i = 0; i < length; ++i) {
            this.nextCharacter();
        }
        return string;
    }

    @Override
    public void appendNextString(StringBuilder builder, int length) {
        builder.append(this.characters, this.position, length);
        for (int i = 0; i < length; ++i) {
            this.nextCharacter();
        }
    }

    @Override
    public String getPast(int maximum) {
        if (0 == this.position) {
            return "";
        }
        int availableLength = Math.min(maximum, this.position);
        return new String(this.characters, this.position - availableLength, availableLength);
    }

    @Override
    public String getFuture(int maximum) {
        int availableLength = Math.min(maximum, this.characters.length - this.position);
        return new String(this.characters, this.position, availableLength);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column + (this.position - this.lastNewLinePosition);
    }

    @Override
    public void close() throws IOException {
    }
}

