/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SuffixedIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private final Payload[] suffixes;
    private boolean suffixing;
    private int suffixIndex = -1;
    private boolean nextCalled;
    private boolean currentRemovable;

    public SuffixedIterator(Iterator<? extends Payload> iterator, Payload ... suffixes) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == suffixes) {
            throw new IllegalArgumentException("The given array of suffixes is null");
        }
        this.iterator = iterator;
        this.suffixes = suffixes;
        this.suffixing = !iterator.hasNext() && 0 != suffixes.length;
    }

    @Override
    public boolean hasNext() {
        return this.suffixing || this.iterator.hasNext();
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextCalled = true;
        if (this.suffixing) {
            this.suffixing = ++this.suffixIndex != this.suffixes.length - 1;
            this.currentRemovable = false;
            return this.suffixes[this.suffixIndex];
        }
        Payload current = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.suffixIndex = -1;
            this.suffixing = 0 != this.suffixes.length;
        }
        this.currentRemovable = true;
        return current;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("MEthod next() hasn't been called yet");
        }
        if (this.currentRemovable) {
            this.iterator.remove();
        }
    }
}

