/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.markenwerk.commons.interfaces.Handler;

public final class RemoveHandlerIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private final Handler<? super Payload> removeHandler;
    private boolean nextCalled;
    private Payload current;
    private boolean currentRemoved;

    public RemoveHandlerIterator(Iterator<? extends Payload> iterator, Handler<? super Payload> removeHandler) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == removeHandler) {
            throw new IllegalArgumentException("The given handler is null");
        }
        this.iterator = iterator;
        this.removeHandler = removeHandler;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Payload next() throws NoSuchElementException {
        this.current = this.iterator.next();
        this.nextCalled = true;
        this.currentRemoved = false;
        return this.current;
    }

    @Override
    public void remove() throws IllegalStateException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Method next() hasn't been called yet");
        }
        if (this.currentRemoved) {
            throw new IllegalStateException("Method remove() has already been called");
        }
        this.currentRemoved = true;
        this.removeHandler.handle(this.current);
    }
}

