/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PrefixedIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private final Payload[] prefixes;
    private boolean prefixing;
    private int prefixIndex = -1;
    private boolean nextCalled;
    private boolean currentRemovable;

    public PrefixedIterator(Iterator<? extends Payload> iterator, Payload ... prefixes) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == prefixes) {
            throw new IllegalArgumentException("The given array of prefixes is null");
        }
        this.iterator = iterator;
        this.prefixes = prefixes;
        this.prefixing = 0 != prefixes.length;
    }

    @Override
    public boolean hasNext() {
        return this.prefixing || this.iterator.hasNext();
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextCalled = true;
        if (this.prefixing) {
            this.prefixing = ++this.prefixIndex != this.prefixes.length - 1;
            this.currentRemovable = false;
            return this.prefixes[this.prefixIndex];
        }
        Payload current = this.iterator.next();
        this.currentRemovable = true;
        return current;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Methiod next() hasn't been called yet");
        }
        if (this.currentRemovable) {
            this.iterator.remove();
        }
    }
}

