/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class NullFreeIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private boolean nextPrepared;
    private Payload next;

    public NullFreeIterator(Iterator<? extends Payload> iterator) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return null != this.next;
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextPrepared = false;
        return this.next;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        this.iterator.remove();
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.next = null;
            while (null == this.next && this.iterator.hasNext()) {
                this.next = this.iterator.next();
            }
            this.nextPrepared = true;
        }
    }
}

