/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.markenwerk.commons.iterators.AbstractProtectedIterator;
import net.markenwerk.commons.iterators.LookAhead;

public final class LookAheadIterator<Payload>
extends AbstractProtectedIterator<LookAhead<Payload>> {
    private final Iterator<? extends Payload> iterator;
    private Entry<Payload> lookAhead = new Entry();
    private boolean nextPrepared;
    private boolean hasNext;

    public LookAheadIterator(Iterator<? extends Payload> iterator) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        this.iterator = iterator;
        if (iterator.hasNext()) {
            this.lookAhead = this.lookAhead.shift(iterator.next(), true);
        }
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.hasNext;
    }

    @Override
    public LookAhead<Payload> next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no next element");
        }
        this.nextPrepared = false;
        return this.lookAhead;
    }

    private void prepareNext() {
        if (!this.nextPrepared) {
            this.hasNext = this.lookAhead.hasNext();
            this.lookAhead = this.iterator.hasNext() ? this.lookAhead.shift(this.iterator.next(), true) : this.lookAhead.shift(null, false);
            this.nextPrepared = true;
        }
    }

    private static class Entry<Payload>
    implements LookAhead<Payload> {
        private final Payload current;
        private final Payload next;
        private final boolean nextExists;

        private Entry() {
            this(null, null, false);
        }

        private Entry(Payload current, Payload next, boolean nextExists) {
            this.current = current;
            this.next = next;
            this.nextExists = nextExists;
        }

        protected Entry<Payload> shift(Payload next, boolean nextExists) {
            return new Entry<Payload>(this.next, next, nextExists);
        }

        @Override
        public Payload get() {
            return this.current;
        }

        @Override
        public Payload getNext() throws NoSuchElementException {
            if (!this.nextExists) {
                throw new NoSuchElementException("LookAhead has no further element");
            }
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.nextExists;
        }

        @Override
        public boolean isLast() {
            return !this.nextExists;
        }

        public String toString() {
            return "LookAhead [current=" + this.current + ", next=" + this.next + ", hasNext=" + this.nextExists + "]";
        }
    }
}

