/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class InfixedIterator<Payload>
implements Iterator<Payload> {
    private final Iterator<? extends Payload> iterator;
    private final Payload[] infixes;
    private boolean infixing;
    private int infixIndex = -1;
    private boolean nextCalled;
    private boolean currentRemovable;

    public InfixedIterator(Iterator<? extends Payload> iterator, Payload ... infixes) throws IllegalArgumentException {
        if (null == iterator) {
            throw new IllegalArgumentException("The given iterator is null");
        }
        if (null == infixes) {
            throw new IllegalArgumentException("The given array of infixes is null");
        }
        this.iterator = iterator;
        this.infixes = infixes;
    }

    @Override
    public boolean hasNext() {
        return this.infixing || this.iterator.hasNext();
    }

    @Override
    public Payload next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("This iterator has no further element");
        }
        this.nextCalled = true;
        if (this.infixing) {
            this.infixing = ++this.infixIndex != this.infixes.length - 1;
            this.currentRemovable = false;
            return this.infixes[this.infixIndex];
        }
        Payload current = this.iterator.next();
        if (this.iterator.hasNext()) {
            this.infixIndex = -1;
            this.infixing = 0 != this.infixes.length;
        }
        this.currentRemovable = true;
        return current;
    }

    @Override
    public void remove() throws IllegalStateException, UnsupportedOperationException {
        if (!this.nextCalled) {
            throw new IllegalStateException("Method next() hasn't been called yet");
        }
        if (this.currentRemovable) {
            this.iterator.remove();
        }
    }
}

